/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.multivariate.unconstrained.conjugatedirection;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.operation.CongruentMatrix;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.optimization.multivariate.unconstrained.steepestdescent.SteepestDescentMinimizer;
import com.numericalmethod.suanshu.optimization.problem.C2OptimProblem;
import com.numericalmethod.suanshu.optimization.problem.IterativeMinimizer;

public class ConjugateGradientMinimizer
extends SteepestDescentMinimizer {
    @Override
    public IterativeMinimizer<Vector> solve(C2OptimProblem problem) throws Exception {
        return new HestenesStiefel(problem);
    }

    public ConjugateGradientMinimizer(double epsilon, int maxIterations) {
        super(epsilon, maxIterations);
    }

    class HestenesStiefel
    extends SteepestDescentMinimizer.SteepestDescentImpl {
        protected Vector dk;
        protected Vector gk;

        protected HestenesStiefel(C2OptimProblem problem) throws Exception {
            super(problem);
            this.gk = null;
            this.dk = null;
        }

        @Override
        public double getIncrement(Vector xk, Vector dk) {
            double a2 = this.gk.innerProduct(this.gk);
            Matrix a3 = (Matrix)this.problem.H().evaluate(xk);
            DenseMatrix a4 = new DenseMatrix(dk);
            CongruentMatrix a5 = new CongruentMatrix((Matrix)a4, a3);
            double a6 = a5.get(1, 1);
            double a7 = a2 / a6;
            return a7;
        }

        @Override
        public Vector getDirection(Vector xk) {
            Vector a2 = (Vector)this.problem.g().evaluate(xk);
            Vector a3 = a2.scaled(-1.0);
            if (this.dk != null) {
                double a4 = a2.innerProduct(a2);
                Vector a5 = this.dk.scaled(a4 /= this.gk.innerProduct(this.gk));
                a3 = a3.add(a5);
            }
            this.gk = a2;
            this.dk = a3;
            return this.dk;
        }
    }
}

