/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.multivariate.unconstrained.quasinewton;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.optimization.multivariate.unconstrained.linesearch.FletcherLineSearch;
import com.numericalmethod.suanshu.optimization.multivariate.unconstrained.steepestdescent.SteepestDescentMinimizer;
import com.numericalmethod.suanshu.optimization.problem.C2OptimProblem;

public abstract class QuasiNewtonMinimizer
extends SteepestDescentMinimizer {
    public QuasiNewtonMinimizer(double epsilon, int maxIterations) {
        super(new FletcherLineSearch(0.1, 0.7, 0.1, 0.75, 1.0E-10, 600), epsilon, maxIterations);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected abstract class QuasiNewtonImpl
    extends SteepestDescentMinimizer.SteepestDescentImpl {
        protected Vector gk;
        protected double ak;
        protected Vector dk;
        protected Matrix Sk;
        private double enum;

        abstract void updateSk(Vector var1);

        @Override
        public double getIncrement(Vector xk, Vector dk) {
            if (this.enum <= QuasiNewtonMinimizer.this.epsilon) {
                return 1.0E-5;
            }
            this.ak = super.getIncrement(xk, dk);
            return this.ak;
        }

        @Override
        public Vector getDirection(Vector xk) {
            Vector a2 = this.gk;
            this.gk = (Vector)this.problem.g().evaluate(xk);
            if (this.dk != null) {
                Vector a3 = this.gk.minus(a2);
                this.enum = a3.norm();
                if (this.enum <= QuasiNewtonMinimizer.this.epsilon) {
                    return this.dk;
                }
                this.updateSk(a3);
            }
            this.dk = this.Sk.multiply(this.gk).scaled(-1.0);
            return this.dk;
        }

        QuasiNewtonImpl(C2OptimProblem a2) throws Exception {
            QuasiNewtonImpl a3;
            super(a2);
            a3.gk = null;
            a3.dk = null;
            a3.enum = Double.POSITIVE_INFINITY;
            int a4 = a2.f().dimensionOfDomain();
            a3.Sk = new DenseMatrix(a4, a4).ONE();
        }
    }
}

