/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.univariate;

import com.numericalmethod.suanshu.analysis.function.rn2r1.univariate.UnivariateRealFunction;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.misc.Constants;
import com.numericalmethod.suanshu.misc.parallel.LoopBody;
import com.numericalmethod.suanshu.misc.parallel.ParallelExecutor;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.number.doublearray.DoubleArrayMath;
import com.numericalmethod.suanshu.optimization.problem.C2OptimProblem;
import com.numericalmethod.suanshu.optimization.univariate.UnivariateMinimizer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class GridSearchMinimizer
implements UnivariateMinimizer {
    protected final int maxIterations;
    private static final ParallelExecutor enum = new ParallelExecutor(GridSearchMinimizer.class.getSimpleName());
    protected final double epsilon;

    @Override
    public Solution solve(C2OptimProblem problem) {
        return this.solve((UnivariateRealFunction)problem.f());
    }

    @Override
    public Solution solve(UnivariateRealFunction f) {
        return new Solution(f);
    }

    public GridSearchMinimizer(double epsilon, int maxIterations) {
        double a2 = Math.sqrt(Constants.EPSILON);
        this.epsilon = epsilon < a2 ? a2 : epsilon;
        this.maxIterations = maxIterations;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class Solution
    implements UnivariateMinimizer.Solution {
        private final UnivariateRealFunction case;
        private double false;
        private double enum;

        @Override
        public double search(double lower, double initial, double upper) {
            ArgumentAssertion.assertTrue(lower < upper, "invalid bracket interval", new Object[0]);
            this.false = Double.POSITIVE_INFINITY;
            double a2 = (upper - lower) / (double)GridSearchMinimizer.this.maxIterations;
            final double[] a3 = DoubleUtils.seq(lower, upper, a2);
            final double[] a4 = new double[a3.length];
            try {
                enum.forLoop(0, a3.length, new LoopBody(){
                    {
                        1 a2;
                    }

                    @Override
                    public void run(int i) throws Exception {
                        double a2;
                        a4[i] = a2 = Solution.this.case.evaluate(a3[i]);
                    }
                });
                this.false = DoubleArrayMath.min(a4);
                int a5 = DoubleUtils.minIndex(a4);
                this.enum = a3[a5];
            }
            catch (Exception a6) {
                for (double a7 = lower; a7 <= upper; a7 += a2) {
                    double a8 = this.case.evaluate(a7);
                    if (!(a8 < this.false)) continue;
                    this.false = a8;
                    this.enum = a7;
                }
            }
            return this.enum;
        }

        @Override
        public double minimum() {
            return this.false;
        }

        @Override
        public Double minimizer() {
            return this.enum;
        }

        @Override
        public double search(double lower, double upper) {
            return this.search(lower, Double.NaN, upper);
        }

        private Solution(UnivariateRealFunction a2) {
            Solution a3;
            a3.case = a2;
        }
    }
}

