/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.cointegration;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.ImmutableMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.eigen.Eigen;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.eigen.EigenProperty;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.triangle.cholesky.Chol;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.triangle.LowerTriangularMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.operation.CongruentMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.operation.Inverse;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.ImmutableVector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.dense.DenseVector;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.misc.PrecisionUtils;
import com.numericalmethod.suanshu.misc.license.Package;
import com.numericalmethod.suanshu.stats.cointegration.AuxiliaryRegression1;
import com.numericalmethod.suanshu.stats.cointegration.AuxiliaryRegression2;
import com.numericalmethod.suanshu.stats.timeseries.datastructure.multivariate.realtime.inttime.MultivariateSimpleTimeSeries;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CointegrationMLE {
    private final int const;
    private final ImmutableVector case;
    private final ImmutableMatrix false;
    private final DenseMatrix enum;

    public ImmutableMatrix beta() {
        return new ImmutableMatrix(this.enum);
    }

    public CointegrationMLE(MultivariateSimpleTimeSeries ts, boolean intercept) {
        this(ts, intercept, 2);
    }

    public ImmutableMatrix alpha() {
        return this.false;
    }

    public ImmutableVector getEigenvalues() {
        return this.case;
    }

    public int rank() {
        return this.case.size();
    }

    public ImmutableVector beta(int r) {
        return new ImmutableVector(this.enum.getColumn(r));
    }

    static {
        Package.validate("STATS");
    }

    public CointegrationMLE(MultivariateSimpleTimeSeries ts, boolean intercept, int p, Matrix D) {
        ArgumentAssertion.assertNotLessThan(p, 1, "p");
        double a2 = PrecisionUtils.autoEpsilon(ts.toMatrix());
        int a3 = ts.dimension();
        int a4 = ts.size();
        int a5 = D == null ? 0 : D.nCols();
        ArgumentAssertion.assertTrue(D == null || D.nRows() == a4, "D and the multivariate time series must have the same number of rows (timed data)", new Object[0]);
        this.const = a4 - p;
        int a6 = a3 * (p - 1) + a5 + (intercept ? 1 : 0);
        ArgumentAssertion.assertTrue(a4 - p > a6 + p * (p + 1) / 2, "the multivariate time series must be long enough for estimation (enough timed data)", new Object[0]);
        AuxiliaryRegression1 a7 = new AuxiliaryRegression1(ts, p, D, intercept);
        AuxiliaryRegression2 a8 = new AuxiliaryRegression2(ts, p, D, intercept);
        ImmutableMatrix a9 = a7.errors();
        ImmutableMatrix a10 = a8.errors();
        Matrix a11 = a9.t().multiply(a9).scaled(1.0 / (double)this.const);
        Matrix a12 = a9.t().multiply(a10).scaled(1.0 / (double)this.const);
        Matrix a13 = a12.t();
        Matrix a14 = a10.t().multiply(a10).scaled(1.0 / (double)this.const);
        Chol a15 = new Chol(a14, a2);
        LowerTriangularMatrix a16 = a15.L();
        Inverse a17 = new Inverse(a16, a2);
        Matrix a18 = a17.multiply(a13).multiply(new Inverse(a11, a2)).multiply(a12).multiply(a17.t());
        Eigen a19 = new Eigen(a18);
        this.case = new ImmutableVector(new DenseVector(a19.getRealEigenvalues()));
        int a20 = this.case.size();
        this.enum = new DenseMatrix(a3, a20);
        for (int a21 = 0; a21 < a20; ++a21) {
            EigenProperty a22 = a19.getProperty(a21);
            Vector a23 = a17.t().multiply(a22.eigenVector());
            a23 = a23.scaled(1.0 / a23.get(1));
            this.enum.setColumn(a21 + 1, a23);
        }
        this.false = new ImmutableMatrix(a12.multiply(this.enum).multiply(new Inverse((Matrix)new CongruentMatrix((Matrix)this.enum, a14), a2)));
    }

    public CointegrationMLE(MultivariateSimpleTimeSeries ts, boolean intercept, int p) {
        this(ts, intercept, p, null);
    }

    public int n() {
        return this.const;
    }
}

