/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.cointegration;

import com.numericalmethod.suanshu.algebra.linear.vector.doubles.ImmutableVector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.dense.DenseVector;
import com.numericalmethod.suanshu.stats.cointegration.CointegrationMLE;
import com.numericalmethod.suanshu.stats.cointegration.JohansenAsymptoticDistribution;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class JohansenTest {
    private final int char;
    private final int new;
    private final JohansenAsymptoticDistribution.TrendType const;
    private final JohansenAsymptoticDistribution.Test case;
    private final int false;
    private JohansenAsymptoticDistribution[] enum = null;

    public ImmutableVector getStats(CointegrationMLE coint) {
        double[] a2 = coint.getEigenvalues().toArray();
        int a3 = a2.length;
        int a4 = coint.n();
        double[] a5 = new double[a3];
        for (int a6 = 0; a6 < a3; ++a6) {
            if (this.case == JohansenAsymptoticDistribution.Test.EIGEN) {
                a5[a6] = (double)(-a4) * Math.log(1.0 - a2[a6]);
                continue;
            }
            int a7 = a3 - a6 - 1;
            if (a6 == 0) {
                a5[a7] = (double)(-a4) * Math.log(1.0 - a2[a7]);
                continue;
            }
            a5[a7] = Math.log(1.0 - a2[a7]);
            int n = a7;
            a5[n] = a5[n] * (double)(-a4);
            int n2 = a7;
            a5[n2] = a5[n2] + a5[a3 - a6];
        }
        return new ImmutableVector(new DenseVector(a5));
    }

    public JohansenTest(JohansenAsymptoticDistribution.Test test, JohansenAsymptoticDistribution.TrendType trend, int dim, int nSim, int nT) {
        this.case = test;
        this.const = trend;
        this.new = dim;
        this.false = nSim;
        this.char = nT;
    }

    public JohansenTest(JohansenAsymptoticDistribution.Test test, JohansenAsymptoticDistribution.TrendType trend, int dim) {
        this(test, trend, dim, 500, 500);
    }

    public int r(CointegrationMLE coint, double level) {
        int a2;
        if (this.enum == null) {
            this.enum = new JohansenAsymptoticDistribution[this.new];
            for (int a3 = 0; a3 < this.new; ++a3) {
                this.enum[a3] = new JohansenAsymptoticDistribution(this.case, this.const, this.new - a3, this.new - a3 <= 2 ? Math.max(5000, this.false) : this.false, this.char);
            }
        }
        double a4 = 1.0 - level;
        double[] a5 = this.getStats(coint).toArray();
        for (a2 = 0; a2 < a5.length && !(a5[a2] < this.enum[a2].quantile(a4)); ++a2) {
        }
        return a2;
    }
}

