/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.covarianceselection;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.ImmutableMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.MatrixPropertyUtils;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.operation.MatrixMeasure;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.misc.PrecisionUtils;
import com.numericalmethod.suanshu.stats.descriptive.correlation.CorrelationMatrix;
import com.numericalmethod.suanshu.stats.descriptive.covariance.SampleCovariance;
import com.numericalmethod.suanshu.stats.timeseries.datastructure.multivariate.MultivariateTimeSeries;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CovarianceSelectionProblem {
    private final double false;
    private final ImmutableMatrix enum;

    public double t() {
        return this.false;
    }

    public CovarianceSelectionProblem(Matrix S, double t) {
        ArgumentAssertion.assertTrue(MatrixPropertyUtils.isSymmetric(S, PrecisionUtils.autoEpsilon(S)), "the covariance matrix must be symmetric", new Object[0]);
        ArgumentAssertion.assertNonNegative(t, "rho, the penalization parameter");
        this.enum = !(S instanceof ImmutableMatrix) ? new ImmutableMatrix(S) : (ImmutableMatrix)S;
        this.false = t;
    }

    public CovarianceSelectionProblem(MultivariateTimeSeries ts, double t, boolean use_cor) {
        this(use_cor ? new CorrelationMatrix(ts.toMatrix()) : new SampleCovariance(ts.toMatrix()), t);
    }

    public ImmutableMatrix S() {
        return this.enum;
    }

    public CovarianceSelectionProblem(MultivariateTimeSeries ts, double t) {
        this(ts, t, true);
    }

    public CovarianceSelectionProblem(CovarianceSelectionProblem that) {
        this.enum = that.enum;
        this.false = that.false;
    }

    protected double functionValueL1(Matrix X) {
        double a2 = Math.log(MatrixMeasure.det(X));
        double a3 = MatrixMeasure.tr(this.enum.multiply(X));
        double a4 = 0.0;
        for (int a5 = 1; a5 <= X.nRows(); ++a5) {
            for (int a6 = 1; a6 <= X.nCols(); ++a6) {
                a4 += Math.abs(X.get(a5, a6));
            }
        }
        double a7 = a2 - a3 - a4;
        return a7;
    }

    protected double functionValueCardinality(Matrix X) {
        double a2 = Math.log(MatrixMeasure.det(X));
        double a3 = MatrixMeasure.tr(this.enum.multiply(X));
        double a4 = 0.0;
        for (int a5 = 1; a5 <= X.nRows(); ++a5) {
            for (int a6 = 1; a6 <= X.nCols(); ++a6) {
                a4 += X.get(a5, a6) != 0.0 ? 1.0 : 0.0;
            }
        }
        double a7 = a2 - a3 - a4;
        return a7;
    }
}

