/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.distribution.multivariate;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.ImmutableMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.MatrixPropertyUtils;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.operation.Inverse;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.operation.MatrixMeasure;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.operation.VariancebtX;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.ImmutableVector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.dense.DenseVector;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.stats.distribution.multivariate.MultivariateProbabilityDistribution;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MultivariateNormalDistribution
implements MultivariateProbabilityDistribution {
    private final double const;
    private final ImmutableMatrix case;
    private final Matrix false;
    private final ImmutableVector enum;

    @Override
    public Vector mean() {
        return this.enum;
    }

    @Override
    public Vector mode() {
        return this.enum;
    }

    private double do() {
        MultivariateNormalDistribution a2;
        double a3 = MatrixMeasure.det(a2.case);
        int a4 = a2.enum.size();
        double a5 = 1.0 / Math.sqrt(Math.pow(Math.PI * 2, a4) * a3);
        return a5;
    }

    @Override
    public double moment(Vector t) {
        double a2 = this.enum.innerProduct(t);
        return a2 += new VariancebtX(t, this.false).doubleValue();
    }

    @Override
    public Matrix covariance() {
        return new ImmutableMatrix(this.case);
    }

    @Override
    public double entropy() {
        int a2 = this.enum.size();
        double a3 = (double)a2 / 2.0 * (1.0 + Math.log(Math.PI * 2));
        return a3 += Math.log(MatrixMeasure.det(this.false)) / 2.0;
    }

    public MultivariateNormalDistribution(Vector mu, Matrix Sigma) {
        ArgumentAssertion.assertTrue(mu.size() == Sigma.nCols() && Sigma.nCols() == Sigma.nRows(), "the size of the mean vector must match the size of the covariance matrix", new Object[0]);
        ArgumentAssertion.assertTrue(MatrixPropertyUtils.isSymmetric(Sigma, 0.0), "the covariance matrix must be symmetric", new Object[0]);
        this.enum = new ImmutableVector(mu);
        this.case = new ImmutableMatrix(Sigma);
        this.false = new Inverse(Sigma);
        this.const = this.do();
    }

    @Override
    public double density(Vector x) {
        Vector a2 = x.minus(this.enum);
        return this.const * Math.exp(-0.5 * a2.innerProduct(this.false.multiply(a2)));
    }

    @Override
    public double cdf(Vector x) {
        throw new UnsupportedOperationException("not yet supported");
    }

    public MultivariateNormalDistribution(int dim) {
        this(new DenseVector(dim), (Matrix)new DenseMatrix(dim, dim).ONE());
    }
}

