/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.distribution.univariate;

import com.numericalmethod.suanshu.analysis.function.special.gamma.Digamma;
import com.numericalmethod.suanshu.analysis.function.special.gamma.GammaRegularizedP;
import com.numericalmethod.suanshu.analysis.function.special.gamma.GammaRegularizedPInverse;
import com.numericalmethod.suanshu.analysis.function.special.gamma.LogGamma;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.stats.distribution.univariate.ProbabilityDistribution;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ChiSquareDistribution
implements ProbabilityDistribution {
    private static final GammaRegularizedPInverse new;
    private static final LogGamma const;
    private final double case;
    private static final GammaRegularizedP false;
    private static final Digamma enum;

    @Override
    public double skew() {
        return Math.sqrt(8.0 / this.case);
    }

    @Override
    public double variance() {
        return 2.0 * this.case;
    }

    @Override
    public double kurtosis() {
        return 12.0 / this.case;
    }

    @Override
    public double cdf(double x) {
        assert (x >= 0.0) : "x must be non-negative";
        return false.evaluate(this.case / 2.0, x / 2.0);
    }

    static {
        const = new LogGamma();
        false = new GammaRegularizedP();
        new = new GammaRegularizedPInverse();
        enum = new Digamma();
    }

    @Override
    public double mean() {
        return this.case;
    }

    public ChiSquareDistribution(double k2) {
        ArgumentAssertion.assertPositive(k2, "k");
        this.case = k2;
    }

    @Override
    public double moment(double t) {
        ArgumentAssertion.assertLessThan(t, 0.5, "t");
        return Math.pow(1.0 - 2.0 * t, -this.case / 2.0);
    }

    @Override
    public double entropy() {
        return this.case / 2.0 + Math.log(2.0) + const.evaluate(this.case / 2.0) + (1.0 - this.case / 2.0) * enum.evaluate(this.case / 2.0);
    }

    @Override
    public double quantile(double u) {
        return 2.0 * new.evaluate(this.case / 2.0, u);
    }

    @Override
    public double median() {
        return this.case - 0.0 + 0.0 / this.case - 0.0 / this.case / this.case;
    }

    @Override
    public double density(double x) {
        if (x < 0.0) {
            return 0.0;
        }
        if (DoubleUtils.isZero(x, 0.0) && this.case < 2.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (DoubleUtils.isZero(x, 0.0) && this.case == 2.0) {
            return 0.5;
        }
        double a2 = Math.pow(0.5, this.case / 2.0);
        double a3 = (this.case / 2.0 - 1.0) * Math.log(x) - x / 2.0 - const.evaluate(this.case / 2.0);
        return a2 *= Math.exp(a3);
    }
}

