/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.distribution.univariate;

import com.numericalmethod.suanshu.misc.license.Package;
import com.numericalmethod.suanshu.stats.distribution.univariate.ProbabilityDistribution;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ExponentialDistribution
implements ProbabilityDistribution {
    private final double enum;

    @Override
    public double cdf(double x) {
        double a2 = x < 0.0 ? 0.0 : 1.0 - Math.exp(-this.enum * x);
        return a2;
    }

    @Override
    public double skew() {
        return 2.0;
    }

    @Override
    public double mean() {
        return 1.0 / this.enum;
    }

    public ExponentialDistribution(double lambda) {
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda > 0");
        }
        this.enum = lambda;
    }

    @Override
    public double median() {
        return Math.log(2.0) / this.enum;
    }

    @Override
    public double density(double x) {
        double a2 = x < 0.0 ? 0.0 : this.enum * Math.exp(-this.enum * x);
        return a2;
    }

    @Override
    public double variance() {
        return 1.0 / this.enum / this.enum;
    }

    @Override
    public double moment(double t) {
        double a2 = 1.0 - t / this.enum;
        a2 = 1.0 / a2;
        return a2;
    }

    public ExponentialDistribution() {
        this(1.0);
    }

    @Override
    public double kurtosis() {
        return 6.0;
    }

    @Override
    public double quantile(double u) {
        double a2 = -Math.log(1.0 - u) / this.enum;
        return a2;
    }

    static {
        Package.validate("BASIC");
    }

    @Override
    public double entropy() {
        return 1.0 - Math.log(this.enum);
    }
}

