/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.distribution.univariate;

import com.numericalmethod.suanshu.analysis.function.special.gamma.GammaRegularizedP;
import com.numericalmethod.suanshu.analysis.function.special.gamma.GammaRegularizedPInverse;
import com.numericalmethod.suanshu.analysis.function.special.gamma.LogGamma;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.stats.distribution.univariate.ProbabilityDistribution;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class GammaDistribution
implements ProbabilityDistribution {
    private final double new;
    private static final GammaRegularizedPInverse const;
    private static final GammaRegularizedP case;
    private final double false;
    private static final LogGamma enum;

    public GammaDistribution(double k2, double theta) {
        ArgumentAssertion.assertPositive(k2, "k");
        ArgumentAssertion.assertPositive(theta, "theta");
        this.false = k2;
        this.new = theta;
    }

    @Override
    public double density(double x) {
        if (x < 0.0) {
            return 0.0;
        }
        if (DoubleUtils.isZero(x, 0.0) && this.false < 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (DoubleUtils.isZero(x, 0.0) && this.false == 1.0) {
            return Math.exp(-enum.evaluate(this.false) - this.false * Math.log(this.new));
        }
        double a2 = (this.false - 1.0) * Math.log(x) - x / this.new - this.false * Math.log(this.new) - enum.evaluate(this.false);
        a2 = Math.exp(a2);
        return a2;
    }

    @Override
    public double median() {
        throw new UnsupportedOperationException("There is no simple closed form.");
    }

    @Override
    public double skew() {
        return 2.0 / Math.sqrt(this.false);
    }

    @Override
    public double quantile(double u) {
        return this.new * const.evaluate(this.false, u);
    }

    @Override
    public double mean() {
        return this.false * this.new;
    }

    @Override
    public double moment(double t) {
        ArgumentAssertion.assertTrue(t < 1.0 / this.new, "only for t < 1/theta", new Object[0]);
        return Math.pow(1.0 - this.new * t, -this.false);
    }

    @Override
    public double cdf(double x) {
        assert (x >= 0.0) : "x must be non-negative";
        return case.evaluate(this.false, x / this.new);
    }

    static {
        enum = new LogGamma();
        case = new GammaRegularizedP();
        const = new GammaRegularizedPInverse();
    }

    @Override
    public double variance() {
        return this.false * this.new * this.new;
    }

    @Override
    public double kurtosis() {
        return 6.0 / this.false;
    }

    @Override
    @Deprecated
    public double entropy() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

