/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.distribution.univariate;

import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.stats.distribution.univariate.NormalDistribution;
import com.numericalmethod.suanshu.stats.distribution.univariate.ProbabilityDistribution;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LogNormalDistribution
implements ProbabilityDistribution {
    private final double case;
    private final NormalDistribution false;
    private final double enum;

    @Override
    public double moment(double s) {
        double a2 = s * this.enum;
        a2 += 0.5 * s * s * this.case * this.case;
        a2 = Math.exp(a2);
        return a2;
    }

    @Override
    public double cdf(double x) {
        if (x <= 0.0) {
            return 0.0;
        }
        return this.false.cdf(Math.log(x));
    }

    @Override
    public double quantile(double u) {
        return Math.exp(this.false.quantile(u));
    }

    @Override
    public double entropy() {
        double a2 = 0.5;
        return a2 += 0.5 * Math.log(Math.PI * 2 * this.case * this.case) + this.enum;
    }

    @Override
    public double variance() {
        double a2 = this.case * this.case;
        double a3 = Math.exp(a2) - 1.0;
        return a3 *= Math.exp(2.0 * this.enum + a2);
    }

    @Override
    public double skew() {
        double a2 = this.case * this.case;
        double a3 = Math.exp(a2);
        double a4 = a3 + 2.0;
        return a4 *= Math.sqrt(a3 - 1.0);
    }

    @Override
    public double mean() {
        double a2 = this.enum + this.case * this.case / 2.0;
        a2 = Math.exp(a2);
        return a2;
    }

    public LogNormalDistribution(double logMu, double logSigma) {
        ArgumentAssertion.assertPositive(logSigma, "logarithm of standard deviation");
        this.enum = logMu;
        this.case = logSigma;
        this.false = new NormalDistribution(logMu, logSigma);
    }

    @Override
    public double density(double x) {
        if (x <= 0.0) {
            return 0.0;
        }
        double a2 = this.false.density(Math.log(x));
        return a2 /= x;
    }

    @Override
    public double median() {
        return Math.exp(this.enum);
    }

    @Override
    public double kurtosis() {
        double a2 = this.case * this.case;
        double a3 = Math.exp(4.0 * a2);
        a3 += 2.0 * Math.exp(3.0 * a2);
        a3 += 3.0 * Math.exp(2.0 * a2);
        return a3 -= 6.0;
    }
}

