/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.distribution.univariate;

import com.numericalmethod.suanshu.analysis.function.special.gaussian.CumulativeNormalInverse;
import com.numericalmethod.suanshu.analysis.function.special.gaussian.CumulativeNormalMarsaglia;
import com.numericalmethod.suanshu.analysis.function.special.gaussian.Gaussian;
import com.numericalmethod.suanshu.analysis.function.special.gaussian.StandardCumulativeNormal;
import com.numericalmethod.suanshu.stats.distribution.univariate.ProbabilityDistribution;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class NormalDistribution
implements ProbabilityDistribution {
    private static CumulativeNormalInverse new;
    private final double const;
    private final double case;
    private static StandardCumulativeNormal false;
    private static Gaussian enum;

    public NormalDistribution(double mu, double sigma) {
        this.case = mu;
        this.const = sigma;
    }

    @Override
    public double mean() {
        return this.case;
    }

    static {
        enum = new Gaussian();
        false = new CumulativeNormalMarsaglia();
        new = new CumulativeNormalInverse();
    }

    public NormalDistribution() {
        this(0.0, 1.0);
    }

    @Override
    public double entropy() {
        return Math.log(Math.PI * 2 * this.const * this.const * Math.E);
    }

    @Override
    public double kurtosis() {
        return 0.0;
    }

    @Override
    public double variance() {
        return this.const * this.const;
    }

    @Override
    public double density(double x) {
        double a2 = (x - this.case) / this.const;
        double a3 = enum.evaluate(a2);
        return a3 /= this.const;
    }

    @Override
    public double quantile(double u) {
        double a2 = new.evaluate(u);
        a2 = this.case + this.const * a2;
        return a2;
    }

    @Override
    public double skew() {
        return 0.0;
    }

    @Override
    public double median() {
        return this.case;
    }

    @Override
    public double cdf(double x) {
        double a2 = (x - this.case) / this.const;
        double a3 = false.evaluate(a2);
        return a3;
    }

    @Override
    public double moment(double t) {
        double a2 = this.case * t;
        a2 += 0.5 * this.const * this.const * t * t;
        a2 = Math.exp(a2);
        return a2;
    }
}

