/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.distribution.univariate;

import com.numericalmethod.suanshu.analysis.function.special.beta.BetaRegularized;
import com.numericalmethod.suanshu.analysis.function.special.beta.BetaRegularizedInverse;
import com.numericalmethod.suanshu.analysis.function.special.beta.LogBeta;
import com.numericalmethod.suanshu.analysis.function.special.gamma.Digamma;
import com.numericalmethod.suanshu.analysis.function.special.gamma.LogGamma;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.misc.ExceptionUtils;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.stats.distribution.univariate.ProbabilityDistribution;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class TDistribution
implements ProbabilityDistribution {
    private final BetaRegularized char;
    private final double new;
    private static final Digamma const;
    private static final LogBeta case;
    private final BetaRegularizedInverse false;
    private static final LogGamma enum;

    @Override
    public double moment(double x) {
        throw new UnsupportedOperationException("not defined.");
    }

    @Override
    public double quantile(double u) {
        double a2 = this.false.evaluate(u);
        double a3 = 0.25 / (a2 - 0.5) / (a2 - 0.5) / this.new - 1.0 / this.new;
        a3 = 1.0 / a3;
        a3 = Math.sqrt(a3);
        a3 = a2 - 0.5 > 0.0 ? a3 : -a3;
        return a3;
    }

    @Override
    public double entropy() {
        double a2 = (this.new + 1.0) / 2.0;
        a2 *= const.evaluate((1.0 + this.new) / 2.0) - const.evaluate(this.new / 2.0);
        return a2 += Math.log(Math.sqrt(this.new)) + case.evaluate(this.new / 2.0, 0.5);
    }

    @Override
    public double median() {
        return 0.0;
    }

    @Override
    public double density(double x) {
        if (DoubleUtils.isZero(x, 0.0)) {
            return 0.0;
        }
        double a2 = enum.evaluate((this.new + 1.0) / 2.0);
        a2 -= Math.log(Math.sqrt(this.new * Math.PI)) + enum.evaluate(this.new / 2.0);
        a2 += -(this.new + 1.0) / 2.0 * Math.log(1.0 + x * x / this.new);
        a2 = Math.exp(a2);
        return a2;
    }

    @Override
    public double cdf(double x) {
        double a2 = x;
        a2 /= 2.0 * Math.sqrt(x * x + this.new);
        return this.char.evaluate(a2 += 0.5);
    }

    @Override
    public double kurtosis() {
        ExceptionUtils.throwIfNotNull(this.new > 4.0 ? null : new UnsupportedOperationException("only for v > 4"));
        return 6.0 / (this.new - 4.0);
    }

    public TDistribution(double v) {
        ArgumentAssertion.assertTrue(v > 0.0, "only for v > 0", new Object[0]);
        this.new = v;
        this.char = new BetaRegularized(v / 2.0, v / 2.0);
        this.false = new BetaRegularizedInverse(v / 2.0, v / 2.0);
    }

    @Override
    public double mean() {
        ExceptionUtils.throwIfNotNull(this.new > 1.0 ? null : new UnsupportedOperationException("only for v > 1"));
        return 0.0;
    }

    @Override
    public double variance() {
        ExceptionUtils.throwIfNotNull(this.new >= 2.0 ? null : new UnsupportedOperationException("only for v >= 2"));
        if (this.new == 2.0) {
            return Double.POSITIVE_INFINITY;
        }
        return this.new / (this.new - 2.0);
    }

    static {
        case = new LogBeta();
        enum = new LogGamma();
        const = new Digamma();
    }

    @Override
    public double skew() {
        ExceptionUtils.throwIfNotNull(this.new > 3.0 ? null : new UnsupportedOperationException("only for v > 3"));
        return 0.0;
    }
}

