/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.distribution.univariate;

import com.numericalmethod.suanshu.misc.Constants;
import com.numericalmethod.suanshu.stats.distribution.univariate.ProbabilityDistribution;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class TriangularDistribution
implements ProbabilityDistribution {
    private final double case;
    private final double false;
    private final double enum;

    @Override
    public double kurtosis() {
        return -0.6;
    }

    @Override
    public double entropy() {
        double a2 = 0.5;
        return a2 += Math.log((this.false - this.enum) / 2.0);
    }

    @Override
    public double mean() {
        double a2 = this.enum + this.false + this.case;
        return a2 /= 3.0;
    }

    @Override
    public double skew() {
        double a2 = Constants.ROOT_2;
        a2 *= (this.enum + this.false - 2.0 * this.case) * (2.0 * this.enum - this.false - this.case) * (this.enum - 2.0 * this.false + this.case);
        a2 /= Math.pow(this.enum * this.enum + this.false * this.false + this.case * this.case - this.enum * this.false - this.enum * this.case - this.false * this.case, 1.5);
        return a2 /= 5.0;
    }

    @Override
    public double cdf(double x) {
        if (x < this.enum) {
            return 0.0;
        }
        if (this.enum <= x && x <= this.case) {
            return (x - this.enum) * (x - this.enum) / ((this.false - this.enum) * (this.case - this.enum));
        }
        if (this.case < x && x <= this.false) {
            return 1.0 - (this.false - x) * (this.false - x) / ((this.false - this.enum) * (this.false - this.case));
        }
        return 1.0;
    }

    @Override
    public double moment(double t) {
        double a2 = 2.0 * (this.false - this.case) * Math.exp(this.enum * t);
        a2 -= (this.false - this.enum) * Math.exp(this.case * t);
        a2 -= (this.case - this.enum) * Math.exp(this.false * t);
        return a2 /= (this.false - this.enum) * (this.case - this.enum) * (this.false - this.case) / t / t;
    }

    @Override
    public double quantile(double u) {
        if (u <= (this.case - this.enum) / (this.false - this.enum)) {
            return this.enum + Math.sqrt(u * (this.false - this.enum) * (this.case - this.enum));
        }
        return this.false - Math.sqrt((1.0 - u) * (this.false - this.enum) * (this.false - this.case));
    }

    public TriangularDistribution(double min, double mode, double max) {
        this.enum = min;
        this.case = mode;
        this.false = max;
    }

    @Override
    public double density(double x) {
        if (x < this.enum || x > this.false) {
            return 0.0;
        }
        if (this.enum <= x && x <= this.case) {
            return 2.0 * (x - this.enum) / ((this.false - this.enum) * (this.case - this.enum));
        }
        return 2.0 * (this.false - x) / ((this.false - this.enum) * (this.false - this.case));
    }

    @Override
    public double variance() {
        double a2 = this.enum * this.enum + this.false * this.false + this.case * this.case - this.enum * this.false - this.enum * this.case - this.false * this.case;
        return a2 /= 18.0;
    }

    @Override
    public double median() {
        double a2 = (this.enum + this.false) / 2.0;
        if (this.case >= a2) {
            double a3 = (this.false - this.enum) * (this.case - this.enum) / 2.0;
            a3 = Math.sqrt(a3);
            return a3 += this.enum;
        }
        double a4 = (this.false - this.enum) * (this.false - this.case) / 2.0;
        a4 = Math.sqrt(a4);
        a4 = this.false - a4;
        return a4;
    }
}

