/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.distribution.univariate;

import com.numericalmethod.suanshu.analysis.function.special.gamma.Gamma;
import com.numericalmethod.suanshu.analysis.function.special.gamma.GammaLanczosQuick;
import com.numericalmethod.suanshu.analysis.sequence.Summation;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.stats.distribution.univariate.ProbabilityDistribution;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class WeibullDistribution
implements ProbabilityDistribution {
    private static final Gamma case = new GammaLanczosQuick();
    private final double false;
    private final double enum;

    @Override
    public double moment(double x) {
        double a2 = 0.0;
        final double a3 = x;
        Summation a4 = new Summation(new Summation.Term(){
            {
                1 a2;
            }

            @Override
            public double evaluate(double n) {
                double a2 = case.evaluate(1.0 + n / WeibullDistribution.this.false);
                int a32 = 1;
                while ((long)a32 <= Math.round(n)) {
                    a2 *= a3 * WeibullDistribution.this.enum / (double)a32;
                    ++a32;
                }
                return a2;
            }
        });
        a2 = a4.sumToInfinity(0.0, 1.0);
        return a2;
    }

    @Override
    public double mean() {
        return this.enum * case.evaluate(1.0 + 1.0 / this.false);
    }

    @Override
    public double cdf(double x) {
        assert (x >= 0.0) : "x must be non-negative";
        return 1.0 - Math.exp(-Math.pow(x / this.enum, this.false));
    }

    @Override
    public double skew() {
        double a2 = this.mean();
        double a3 = Math.sqrt(this.variance());
        double a4 = case.evaluate(1.0 + 3.0 / this.false) * this.enum * this.enum * this.enum;
        a4 -= 3.0 * a2 * a3 * a3;
        a4 -= a2 * a2 * a2;
        return a4 /= a3 * a3 * a3;
    }

    @Override
    public double density(double x) {
        if (x < 0.0) {
            return 0.0;
        }
        double a2 = this.false / this.enum;
        a2 *= Math.pow(x / this.enum, this.false - 1.0);
        return a2 *= Math.exp(-Math.pow(x / this.enum, this.false));
    }

    @Override
    public double quantile(double u) {
        return this.enum * Math.pow(-Math.log(1.0 - u), 1.0 / this.false);
    }

    @Override
    public double variance() {
        double a2 = this.mean();
        return this.enum * this.enum * case.evaluate(1.0 + 2.0 / this.false) - a2 * a2;
    }

    @Override
    public double median() {
        return this.enum * Math.pow(Math.log(2.0), 1.0 / this.false);
    }

    @Override
    public double entropy() {
        return 0.5772156649015329 * (1.0 - 1.0 / this.false) + Math.log(this.enum / this.false) + 1.0;
    }

    public WeibullDistribution(double lambda, double k2) {
        ArgumentAssertion.assertPositive(lambda, "lambda");
        ArgumentAssertion.assertPositive(k2, "k");
        this.enum = lambda;
        this.false = k2;
    }

    @Override
    public double kurtosis() {
        double a2 = this.mean();
        double a3 = Math.sqrt(this.variance());
        double a4 = this.skew();
        double a5 = case.evaluate(1.0 + 4.0 / this.false) * this.enum * this.enum * this.enum * this.enum;
        a5 -= 4.0 * a4 * a3 * a3 * a3 * a2;
        a5 -= 6.0 * a2 * a2 * a3 * a3;
        a5 -= a2 * a2 * a2 * a2;
        a5 /= a3 * a3 * a3 * a3;
        return a5 -= 3.0;
    }
}

