/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.dlm.multivariate;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.ImmutableMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.triangle.cholesky.CholeskyWang2006;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.triangle.LowerTriangularMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.operation.MatrixUtils;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.operation.SimilarMatrix;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.ImmutableVector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.dense.DenseVector;
import com.numericalmethod.suanshu.analysis.function.matrix.R1toConstantMatrix;
import com.numericalmethod.suanshu.analysis.function.matrix.R1toMatrix;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.misc.PrecisionUtils;
import com.numericalmethod.suanshu.stats.dlm.univariate.ObservationEquation;
import com.numericalmethod.suanshu.stats.random.rng.multivariate.NormalRVG;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MultivariateObservationEquation {
    private final R1toMatrix const;
    private final R1toMatrix case;
    private final NormalRVG false;
    private final int enum;

    public MultivariateObservationEquation(final ObservationEquation obs) {
        this(new R1toMatrix(){
            {
                1 a2;
            }

            @Override
            public Matrix evaluate(double t) {
                return new DenseMatrix(new double[][]{{obs.F((int)t)}});
            }
        }, new R1toMatrix(){
            {
                2 a2;
            }

            @Override
            public Matrix evaluate(double t) {
                return new DenseMatrix(new double[][]{{obs.V((int)t)}});
            }
        });
    }

    public ImmutableMatrix yt_var(int t, Matrix var_t_tlag) {
        ImmutableMatrix a2 = this.F(t);
        ImmutableMatrix a3 = this.V(t);
        Matrix a4 = new SimilarMatrix(a2.t(), var_t_tlag).add(a3);
        return new ImmutableMatrix(a4);
    }

    public ImmutableVector yt(int t, Vector xt) {
        Vector a2 = this.yt_mean(t, xt);
        Matrix a3 = this.case.evaluate(t);
        LowerTriangularMatrix a4 = new CholeskyWang2006(a3, PrecisionUtils.autoEpsilon(MatrixUtils.to1DArray(a3))).L();
        Vector a5 = a4.multiply(new DenseVector(this.false.nextVector()));
        a2 = a2.add(a5);
        return new ImmutableVector(a2);
    }

    public MultivariateObservationEquation(R1toMatrix F2, R1toMatrix V) {
        this(F2, V, null);
    }

    public ImmutableMatrix V(int t) {
        return new ImmutableMatrix(this.case.evaluate(t));
    }

    public MultivariateObservationEquation(MultivariateObservationEquation that) {
        this(that.const, that.case);
    }

    public ImmutableVector yt_mean(int t, Vector xt) {
        Vector a2 = this.const.evaluate(t).multiply(xt);
        return new ImmutableVector(a2);
    }

    public MultivariateObservationEquation(Matrix F2, Matrix V, NormalRVG rmvnorm) {
        this(new R1toConstantMatrix(F2), new R1toConstantMatrix(V), rmvnorm);
    }

    public MultivariateObservationEquation(R1toMatrix F2, R1toMatrix V, NormalRVG rmvnorm) {
        this.enum = F2.evaluate(1.0).nRows();
        ArgumentAssertion.assertTrue(V.evaluate(1.0).nRows() == this.enum && V.evaluate(1.0).nCols() == this.enum, "the dimension of V is the same as the dimension of observation y_t", new Object[0]);
        this.const = F2;
        this.case = V;
        this.false = rmvnorm == null ? new NormalRVG(this.enum) : rmvnorm;
    }

    public int dimension() {
        return this.enum;
    }

    public ImmutableMatrix F(int t) {
        return new ImmutableMatrix(this.const.evaluate(t));
    }

    public MultivariateObservationEquation(Matrix F2, Matrix V) {
        this(new R1toConstantMatrix(F2), new R1toConstantMatrix(V), null);
    }
}

