/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.dlm.multivariate;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.ImmutableMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.triangle.cholesky.CholeskyWang2006;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.triangle.LowerTriangularMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.operation.CongruentMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.operation.MatrixUtils;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.ImmutableVector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.dense.DenseVector;
import com.numericalmethod.suanshu.analysis.function.matrix.R1toConstantMatrix;
import com.numericalmethod.suanshu.analysis.function.matrix.R1toMatrix;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.misc.PrecisionUtils;
import com.numericalmethod.suanshu.misc.license.Package;
import com.numericalmethod.suanshu.stats.dlm.univariate.StateEquation;
import com.numericalmethod.suanshu.stats.random.rng.multivariate.NormalRVG;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MultivariateStateEquation {
    private final NormalRVG new;
    private final R1toMatrix const;
    private final R1toMatrix case;
    private final int false;
    private final R1toMatrix enum;

    public Vector xt_mean(int t, Vector xt_1) {
        return this.xt_mean(t, xt_1, null);
    }

    public MultivariateStateEquation(Matrix G2, Matrix H, Matrix W, NormalRVG rmvnorm) {
        this(new R1toConstantMatrix(G2), H != null ? new R1toConstantMatrix(H) : null, new R1toConstantMatrix(W), rmvnorm);
    }

    public MultivariateStateEquation(R1toMatrix G2, R1toMatrix W) {
        this(G2, null, W);
    }

    public MultivariateStateEquation(Matrix G2, Matrix W) {
        this(G2, null, W, null);
    }

    static {
        Package.validate("STATS");
    }

    public Vector xt_mean(int t, Vector xt_1, Vector ut) {
        Vector a2 = this.case.evaluate(t).multiply(xt_1);
        if (this.enum != null) {
            Vector a3 = this.enum.evaluate(t).multiply(ut);
            a2 = a2.add(a3);
        }
        return a2;
    }

    public ImmutableVector xt(int t, Vector xt_1) {
        ArgumentAssertion.assertTrue(this.enum == null, "H is not null and thus it requires the control variable", new Object[0]);
        return this.xt(t, xt_1, null);
    }

    public ImmutableVector xt(int t, Vector xt_1, Vector ut) {
        Vector a2 = this.xt_mean(t, xt_1, ut);
        Matrix a3 = this.const.evaluate(t);
        LowerTriangularMatrix a4 = new CholeskyWang2006(a3, PrecisionUtils.autoEpsilon(MatrixUtils.to1DArray(a3))).L();
        Vector a5 = a4.multiply(new DenseVector(this.new.nextVector()));
        a2 = a2.add(a5);
        return new ImmutableVector(a2);
    }

    public Matrix G(int t) {
        return this.case.evaluate(t);
    }

    public MultivariateStateEquation(MultivariateStateEquation that) {
        this(that.case, that.enum, that.const);
    }

    public MultivariateStateEquation(final StateEquation states) {
        this(new R1toMatrix(){
            {
                1 a2;
            }

            @Override
            public Matrix evaluate(double t) {
                return new DenseMatrix(new double[][]{{states.G((int)t)}});
            }
        }, new R1toMatrix(){
            {
                2 a2;
            }

            @Override
            public Matrix evaluate(double t) {
                return new DenseMatrix(new double[][]{{states.H((int)t)}});
            }
        }, new R1toMatrix(){
            {
                3 a2;
            }

            @Override
            public Matrix evaluate(double t) {
                return new DenseMatrix(new double[][]{{states.W((int)t)}});
            }
        });
    }

    public Matrix H(int t) {
        return this.enum != null ? this.enum.evaluate(t) : null;
    }

    public ImmutableMatrix xt_var(int t, Matrix var_tlag_tlag) {
        Matrix a2 = this.G(t);
        Matrix a3 = this.W(t);
        Matrix a4 = new CongruentMatrix(a2.t(), var_tlag_tlag).add(a3);
        return new ImmutableMatrix(a4);
    }

    public MultivariateStateEquation(R1toMatrix G2, R1toMatrix H, R1toMatrix W) {
        this(G2, H, W, null);
    }

    public MultivariateStateEquation(R1toMatrix G2, R1toMatrix H, R1toMatrix W, NormalRVG rmvnorm) {
        this.false = G2.evaluate(1.0).nRows();
        ArgumentAssertion.assertTrue(W.evaluate(1.0).nRows() == this.false && W.evaluate(1.0).nCols() == this.false, "the dimension of W is the dimension of each state x_t", new Object[0]);
        if (H != null) {
            ArgumentAssertion.assertTrue(H.evaluate(1.0).nRows() == this.false, "the dimension of W is the dimension of each state x_t", new Object[0]);
        }
        this.case = G2;
        this.enum = H;
        this.const = W;
        this.new = rmvnorm == null ? new NormalRVG(this.false) : rmvnorm;
    }

    public Matrix W(int t) {
        return this.const.evaluate(t);
    }

    public int dimension() {
        return this.false;
    }
}

