/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.evt.evd.bivariate;

import com.numericalmethod.suanshu.analysis.function.rn2r1.univariate.AbstractUnivariateRealFunction;
import com.numericalmethod.suanshu.analysis.root.univariate.BrentRoot;
import com.numericalmethod.suanshu.analysis.root.univariate.NoRootFoundException;
import com.numericalmethod.suanshu.analysis.root.univariate.Uniroot;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.misc.Constants;
import com.numericalmethod.suanshu.misc.license.Package;
import com.numericalmethod.suanshu.stats.evt.evd.bivariate.BivariateEVD;
import com.numericalmethod.suanshu.stats.evt.evd.univariate.GeneralizedEVD;
import com.numericalmethod.suanshu.stats.random.rng.univariate.uniform.UniformRNG;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BivariateEVDAsymmetricMixed
implements BivariateEVD {
    private final UniformRNG char = new UniformRNG();
    private static final Uniroot new;
    private final double const;
    private final double case;
    private final GeneralizedEVD false;
    private final GeneralizedEVD enum;

    private double do(double a2, double a3) {
        BivariateEVDAsymmetricMixed a4;
        double a5 = -Math.log(a2);
        double a6 = -Math.log(a3);
        double a7 = a5 / (a5 + a6);
        double a8 = a5 + a6 - a5 * (a4.const + a4.case - a4.const * a7 - a4.case * a7 * a7);
        double a9 = 1.0 - a4.const * a7 * a7 - 2.0 * a4.case * a7 * a7 * a7;
        double a10 = Math.exp(-a8) * (1.0 / a3) * a9;
        return a10;
    }

    @Override
    public double density(double x1, double x2) {
        double a2;
        double a3 = this.enum.marginalTransform(x1);
        double a4 = this.false.marginalTransform(x2);
        if (a3 == 0.0 || a4 == 0.0 || Double.isInfinite(a3) || Double.isInfinite(a4)) {
            a2 = Double.NEGATIVE_INFINITY;
        } else {
            double a5 = a3 + a4;
            double a6 = a5 - (this.const + this.case) * a3 + this.const * a3 * a3 / a5 + this.case * a3 * a3 * a3 / a5 / a5;
            double a7 = Math.log(a3);
            double a8 = Math.log(a4);
            double a9 = (1.0 + this.enum.getShape()) * a7 + (1.0 + this.false.getShape()) * a8 - Math.log(this.enum.getScale() * this.false.getScale());
            double a10 = a3 / a5;
            double a11 = a4 / a5;
            double a12 = 1.0 - this.const * a11 * a11 - this.case * (3.0 * a11 * a11 - 2.0 * a11 * a11 * a11);
            double a13 = 1.0 - this.const * a10 * a10 - 2.0 * this.case * a10 * a10 * a10;
            double a14 = (-2.0 * this.const * a10 * a11 - 6.0 * this.case * a10 * a10 * a11) / a5;
            a2 = Math.log(a12 * a13 - a14) - a6 + a9;
        }
        return Math.exp(a2);
    }

    @Override
    public void seed(long ... seeds) {
        this.char.seed(seeds);
    }

    @Override
    public double conditionalCopula(double x1, double x2) {
        ArgumentAssertion.assertRangeOpen(x1, 0.0, 1.0, "x1");
        ArgumentAssertion.assertRangeOpen(x2, 0.0, 1.0, "x2");
        return this.do(x1, x2);
    }

    @Override
    public double cdf(double x1, double x2) {
        double a2 = this.enum.marginalTransform(x1);
        double a3 = this.false.marginalTransform(x2);
        if (Double.isInfinite(a2) || Double.isInfinite(a3)) {
            return 0.0;
        }
        double a4 = a2 + a3;
        if (a4 == 0.0) {
            return 1.0;
        }
        double a5 = a2 * a2;
        double a6 = a4 - (this.const + this.case) * a2 + this.const * a5 / a4 + this.case * a5 * a2 / a4 / a4;
        return Math.exp(-a6);
    }

    public BivariateEVDAsymmetricMixed(double alpha, double beta, GeneralizedEVD marginal1, GeneralizedEVD marginal2) {
        ArgumentAssertion.assertNonNegative(alpha, "alpha");
        ArgumentAssertion.assertNotGreaterThan(alpha + beta, 1.0, "alpha + beta");
        ArgumentAssertion.assertNotGreaterThan(alpha + 2.0 * beta, 1.0, "alpha + 2*beta");
        ArgumentAssertion.assertNonNegative(alpha + 3.0 * beta, "alpha + 3*beta");
        this.const = alpha;
        this.case = beta;
        this.enum = marginal1;
        this.false = marginal2;
    }

    @Override
    public double[] nextVector() {
        double a2;
        final double[] a3 = new double[]{this.char.nextDouble(), this.char.nextDouble()};
        AbstractUnivariateRealFunction a4 = new AbstractUnivariateRealFunction(){
            {
                1 a2;
            }

            @Override
            public double evaluate(double x) {
                return BivariateEVDAsymmetricMixed.this.do(x, a3[1]) - a3[0];
            }
        };
        try {
            a2 = new.solve(a4, Constants.MACH_EPS, 1.0 - Constants.MACH_EPS, new double[0]);
        }
        catch (NoRootFoundException a5) {
            a2 = a5.x();
        }
        a3[0] = a2;
        double a6 = this.enum.marginalInverseTransform(-Math.log(a3[0]));
        double a7 = this.false.marginalInverseTransform(-Math.log(a3[1]));
        return new double[]{a6, a7};
    }

    public BivariateEVDAsymmetricMixed(double alpha, double beta, GeneralizedEVD marginal) {
        this(alpha, beta, marginal, marginal);
    }

    static {
        Package.validate("EVT");
        new = new BrentRoot(Constants.EPSILON, Integer.MAX_VALUE);
    }

    @Override
    public double spectralDensity(double x) {
        ArgumentAssertion.assertRange(x, 0.0, 1.0, "x");
        return 2.0 * this.const + 6.0 * this.case * (1.0 - x);
    }

    @Override
    public double dependence(double x) {
        ArgumentAssertion.assertRange(x, 0.0, 1.0, "x");
        return 1.0 - (this.const + this.case) * x + this.const * x * x + this.case * x * x * x;
    }

    public BivariateEVDAsymmetricMixed(double alpha, double beta) {
        this(alpha, beta, new GeneralizedEVD());
    }
}

