/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.evt.evd.bivariate;

import com.numericalmethod.suanshu.analysis.function.rn2r1.univariate.AbstractUnivariateRealFunction;
import com.numericalmethod.suanshu.analysis.root.univariate.BrentRoot;
import com.numericalmethod.suanshu.analysis.root.univariate.NoRootFoundException;
import com.numericalmethod.suanshu.analysis.root.univariate.Uniroot;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.misc.Constants;
import com.numericalmethod.suanshu.misc.license.Package;
import com.numericalmethod.suanshu.stats.evt.evd.bivariate.BivariateEVD;
import com.numericalmethod.suanshu.stats.evt.evd.univariate.GeneralizedEVD;
import com.numericalmethod.suanshu.stats.random.rng.univariate.uniform.UniformRNG;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BivariateEVDAsymmetricNegativeLogistic
implements BivariateEVD {
    private final UniformRNG super = new UniformRNG();
    private final GeneralizedEVD char;
    private final GeneralizedEVD new;
    private final double const;
    private static final Uniroot case;
    private final double false;
    private final double enum;

    @Override
    public double[] nextVector() {
        final double[] a2 = new double[]{this.super.nextDouble(), this.super.nextDouble()};
        AbstractUnivariateRealFunction a3 = new AbstractUnivariateRealFunction(){
            {
                1 a22;
            }

            @Override
            public double evaluate(double x) {
                return BivariateEVDAsymmetricNegativeLogistic.this.do(x, a2[1]) - a2[0];
            }
        };
        try {
            a2[0] = case.solve(a3, Constants.MACH_EPS, 1.0 - Constants.MACH_EPS, new double[0]);
        }
        catch (NoRootFoundException a4) {
            a2[0] = a4.x();
        }
        double a5 = this.char.marginalInverseTransform(-Math.log(a2[0]));
        double a6 = this.new.marginalInverseTransform(-Math.log(a2[1]));
        return new double[]{a5, a6};
    }

    private double do(double a2, double a3) {
        BivariateEVDAsymmetricNegativeLogistic a4;
        double a5 = -Math.log(a2);
        double a6 = -Math.log(a3);
        double a7 = 1.0 / a4.enum;
        double a8 = Math.pow(a4.false * a6, -a4.enum) + Math.pow(a4.const * a5, -a4.enum);
        double a9 = Math.exp(Math.pow(a8, -a7)) * a2 * (1.0 - Math.pow(a4.false, -a4.enum) * Math.pow(a6, -a4.enum - 1.0) * Math.pow(a8, -a7 - 1.0));
        return a9;
    }

    public BivariateEVDAsymmetricNegativeLogistic(double dependence, double asymmetry1, double asymmetry2) {
        this(dependence, asymmetry1, asymmetry2, new GeneralizedEVD());
    }

    @Override
    public void seed(long ... seeds) {
        this.super.seed(seeds);
    }

    static {
        Package.validate("EVT");
        case = new BrentRoot(Constants.EPSILON, Integer.MAX_VALUE);
    }

    @Override
    public double density(double x1, double x2) {
        double a2;
        double a3 = this.char.marginalTransform(x1);
        double a4 = this.new.marginalTransform(x2);
        if (a3 == 0.0 || a4 == 0.0 || Double.isInfinite(a3) || Double.isInfinite(a4)) {
            a2 = Double.NEGATIVE_INFINITY;
        } else {
            double a5 = 1.0 / this.enum;
            double a6 = Math.pow(Math.pow(a3 * this.false, -this.enum) + Math.pow(a4 * this.const, -this.enum), -a5);
            double a7 = a3 + a4 - a6;
            double a8 = -this.enum * Math.log(this.false);
            double a9 = -this.enum * Math.log(this.const);
            double a10 = Math.log(a3);
            double a11 = Math.log(a4);
            double a12 = (-this.enum - 1.0) * a10;
            double a13 = (-this.enum - 1.0) * a11;
            double a14 = (1.0 + this.char.getShape()) * a10 + (1.0 + this.new.getShape()) * a11 - Math.log(this.char.getScale() * this.new.getScale());
            double a15 = a8 + a12;
            double a16 = a9 + a13;
            double a17 = (1.0 + this.enum) * Math.log(a6) + Math.log(Math.exp(a15) + Math.exp(a16));
            double a18 = a8 + a9 + a12 + a13 + (1.0 + 2.0 * this.enum) * Math.log(a6) + Math.log(this.enum + 1.0 + a6);
            a2 = Math.log(1.0 - Math.exp(a17) + Math.exp(a18)) - a7 + a14;
        }
        return Math.exp(a2);
    }

    public BivariateEVDAsymmetricNegativeLogistic(double dependence) {
        this(dependence, 1.0, 1.0);
    }

    public BivariateEVDAsymmetricNegativeLogistic(double dependence, double asymmetry1, double asymmetry2, GeneralizedEVD marginal1, GeneralizedEVD marginal2) {
        ArgumentAssertion.assertPositive(dependence, "dependence");
        ArgumentAssertion.assertRange(asymmetry1, 0.0, 1.0, "asymmetry1");
        ArgumentAssertion.assertRange(asymmetry2, 0.0, 1.0, "asymmetry2");
        this.enum = dependence;
        this.false = asymmetry1;
        this.const = asymmetry2;
        this.char = marginal1;
        this.new = marginal2;
    }

    @Override
    public double cdf(double x1, double x2) {
        double a2 = this.char.marginalTransform(x1);
        double a3 = this.new.marginalTransform(x2);
        double a4 = a2 + a3 - Math.pow(Math.pow(a2 * this.false, -this.enum) + Math.pow(a3 * this.const, -this.enum), -1.0 / this.enum);
        return Math.exp(-a4);
    }

    @Override
    public double conditionalCopula(double x1, double x2) {
        ArgumentAssertion.assertRangeOpen(x1, 0.0, 1.0, "x1");
        ArgumentAssertion.assertRangeOpen(x2, 0.0, 1.0, "x2");
        return this.do(x1, x2);
    }

    @Override
    public double spectralDensity(double x) {
        ArgumentAssertion.assertRange(x, 0.0, 1.0, "x");
        return (1.0 + this.enum) * Math.pow(this.false * this.const, -this.enum) * Math.pow(x * (1.0 - x), this.enum - 1.0) * Math.pow(Math.pow(x / this.false, this.enum) + Math.pow((1.0 - x) / this.const, this.enum), -1.0 / this.enum - 2.0);
    }

    public BivariateEVDAsymmetricNegativeLogistic(double dependence, double asymmetry1, double asymmetry2, GeneralizedEVD marginal) {
        this(dependence, asymmetry1, asymmetry2, marginal, marginal);
    }

    @Override
    public double dependence(double x) {
        ArgumentAssertion.assertRange(x, 0.0, 1.0, "x");
        return 1.0 - Math.pow(Math.pow(this.false * x, -this.enum) + Math.pow(this.const * (1.0 - x), -this.enum), -1.0 / this.enum);
    }
}

