/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.evt.evd.bivariate;

import com.numericalmethod.suanshu.analysis.function.rn2r1.univariate.AbstractUnivariateRealFunction;
import com.numericalmethod.suanshu.analysis.root.univariate.BrentRoot;
import com.numericalmethod.suanshu.analysis.root.univariate.NoRootFoundException;
import com.numericalmethod.suanshu.analysis.root.univariate.Uniroot;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.misc.Constants;
import com.numericalmethod.suanshu.misc.license.Package;
import com.numericalmethod.suanshu.stats.distribution.univariate.BetaDistribution;
import com.numericalmethod.suanshu.stats.evt.evd.bivariate.BivariateEVD;
import com.numericalmethod.suanshu.stats.evt.evd.univariate.GeneralizedEVD;
import com.numericalmethod.suanshu.stats.random.rng.univariate.uniform.UniformRNG;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BivariateEVDColesTawn
implements BivariateEVD {
    private final double char;
    private final UniformRNG new = new UniformRNG();
    private final double const;
    private final GeneralizedEVD case;
    private static final Uniroot false;
    private final GeneralizedEVD enum;

    @Override
    public double spectralDensity(double x) {
        ArgumentAssertion.assertRange(x, 0.0, 1.0, "x");
        double a2 = this.const * x / (this.const * x + this.char * (1.0 - x));
        double a3 = this.const * this.char / (this.const + this.char + 1.0);
        double a4 = new BetaDistribution(this.const + 1.0, this.char + 1.0).density(a2) / (this.const * x * x * (1.0 - x) + this.char * x * (1.0 - x) * (1.0 - x)) * a3;
        return a4;
    }

    private double do(double a2, double a3) {
        BivariateEVDColesTawn a4;
        double a5 = -Math.log(a2);
        double a6 = -Math.log(a3);
        double a7 = a4.const * a6 / (a4.const * a6 + a4.char * a5);
        double a8 = a5 * (1.0 - new BetaDistribution(a4.const + 1.0, a4.char).cdf(a7)) + a6 * new BetaDistribution(a4.const, a4.char + 1.0).cdf(a7);
        double a9 = Math.exp(-a8) * (1.0 / a3) * new BetaDistribution(a4.const, a4.char + 1.0).cdf(a7);
        return a9;
    }

    @Override
    public void seed(long ... seeds) {
        this.new.seed(seeds);
    }

    @Override
    public double dependence(double x) {
        ArgumentAssertion.assertRange(x, 0.0, 1.0, "x");
        double a2 = this.const * (1.0 - x) / (this.const * (1.0 - x) + this.char * x);
        return (1.0 - x) * new BetaDistribution(this.const, this.char + 1.0).cdf(a2) + x * (1.0 - new BetaDistribution(this.const + 1.0, this.char).cdf(a2));
    }

    @Override
    public double density(double x1, double x2) {
        double a2;
        double a3 = this.case.marginalTransform(x1);
        double a4 = this.enum.marginalTransform(x2);
        if (a3 == 0.0 || a4 == 0.0 || Double.isInfinite(a3) || Double.isInfinite(a4)) {
            a2 = Double.NEGATIVE_INFINITY;
        } else {
            double a5 = this.const * a4 / (this.const * a4 + this.char * a3);
            double a6 = a4 * new BetaDistribution(this.const, this.char + 1.0).cdf(a5) + a3 * (1.0 - new BetaDistribution(this.const + 1.0, this.char).cdf(a5));
            double a7 = Math.log(a3);
            double a8 = Math.log(a4);
            double a9 = (1.0 + this.case.getShape()) * a7 + (1.0 + this.enum.getShape()) * a8 - Math.log(this.case.getScale() * this.enum.getScale());
            double a10 = this.const * this.char / (this.const + this.char + 1.0);
            double a11 = new BetaDistribution(this.const, this.char + 1.0).cdf(a5) * (1.0 - new BetaDistribution(this.const + 1.0, this.char).cdf(a5));
            double a12 = new BetaDistribution(this.const + 1.0, this.char + 1.0).density(a5) / (this.const * a4 + this.char * a3);
            a2 = Math.log(a11 + a10 * a12) - a6 + a9;
        }
        return Math.exp(a2);
    }

    @Override
    public double[] nextVector() {
        double a2;
        final double[] a3 = new double[]{this.new.nextDouble(), this.new.nextDouble()};
        AbstractUnivariateRealFunction a4 = new AbstractUnivariateRealFunction(){

            @Override
            public double evaluate(double x) {
                return BivariateEVDColesTawn.this.do(x, a3[1]) - a3[0];
            }
            {
                1 a2;
            }
        };
        try {
            a2 = false.solve(a4, Constants.MACH_EPS, 1.0 - Constants.MACH_EPS, new double[0]);
        }
        catch (NoRootFoundException a5) {
            a2 = a5.x();
        }
        a3[0] = a2;
        double a6 = this.case.marginalInverseTransform(-Math.log(a3[0]));
        double a7 = this.enum.marginalInverseTransform(-Math.log(a3[1]));
        return new double[]{a6, a7};
    }

    static {
        Package.validate("EVT");
        false = new BrentRoot(Constants.EPSILON, Integer.MAX_VALUE);
    }

    @Override
    public double cdf(double x1, double x2) {
        double a2 = this.case.marginalTransform(x1);
        double a3 = this.case.marginalTransform(x2);
        if (Double.isInfinite(a2) || Double.isInfinite(a3)) {
            return 0.0;
        }
        if (a2 + a3 == 0.0) {
            return 1.0;
        }
        double a4 = this.const * a3 / (this.const * a3 + this.char * a2);
        double a5 = a3 * new BetaDistribution(this.const, this.char + 1.0).cdf(a4) + a2 * (1.0 - new BetaDistribution(this.const + 1.0, this.char).cdf(a4));
        return Math.exp(-a5);
    }

    public BivariateEVDColesTawn(double alpha, double beta, GeneralizedEVD marginal1, GeneralizedEVD marginal2) {
        ArgumentAssertion.assertPositive(alpha, "alpha");
        ArgumentAssertion.assertPositive(beta, "beta");
        this.const = alpha;
        this.char = beta;
        this.case = marginal1;
        this.enum = marginal2;
    }

    public BivariateEVDColesTawn(double alpha, double beta) {
        this(alpha, beta, new GeneralizedEVD());
    }

    @Override
    public double conditionalCopula(double x1, double x2) {
        ArgumentAssertion.assertRangeOpen(x1, 0.0, 1.0, "x1");
        ArgumentAssertion.assertRangeOpen(x2, 0.0, 1.0, "x2");
        return this.do(x1, x2);
    }

    public BivariateEVDColesTawn(double alpha, double beta, GeneralizedEVD marginal) {
        this(alpha, beta, marginal, marginal);
    }
}

