/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.evt.evd.bivariate;

import com.numericalmethod.suanshu.analysis.function.rn2r1.univariate.AbstractUnivariateRealFunction;
import com.numericalmethod.suanshu.analysis.root.univariate.BrentRoot;
import com.numericalmethod.suanshu.analysis.root.univariate.NoRootFoundException;
import com.numericalmethod.suanshu.analysis.root.univariate.Uniroot;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.misc.Constants;
import com.numericalmethod.suanshu.misc.license.Package;
import com.numericalmethod.suanshu.stats.distribution.univariate.NormalDistribution;
import com.numericalmethod.suanshu.stats.evt.evd.bivariate.BivariateEVD;
import com.numericalmethod.suanshu.stats.evt.evd.univariate.GeneralizedEVD;
import com.numericalmethod.suanshu.stats.random.rng.univariate.uniform.UniformRNG;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BivariateEVDHuslerReiss
implements BivariateEVD {
    private final GeneralizedEVD new;
    private static final Uniroot const;
    private final double case;
    private final GeneralizedEVD false;
    private final UniformRNG enum = new UniformRNG();

    public BivariateEVDHuslerReiss(double dependence, GeneralizedEVD marginal1, GeneralizedEVD marginal2) {
        ArgumentAssertion.assertPositive(dependence, "dependence");
        this.case = dependence;
        this.false = marginal1;
        this.new = marginal2;
    }

    public BivariateEVDHuslerReiss(double dependence, GeneralizedEVD marginal) {
        this(dependence, marginal, marginal);
    }

    @Override
    public void seed(long ... seeds) {
        this.enum.seed(seeds);
    }

    @Override
    public double density(double x1, double x2) {
        double a2;
        double a3 = this.false.marginalTransform(x1);
        double a4 = this.new.marginalTransform(x2);
        if (a3 == 0.0 || a4 == 0.0 || Double.isInfinite(a3) || Double.isInfinite(a4)) {
            a2 = Double.NEGATIVE_INFINITY;
        } else {
            NormalDistribution a5 = new NormalDistribution();
            double a6 = a3 * a5.cdf(1.0 / this.case + this.case * Math.log(a3 / a4) / 2.0) + a4 * a5.cdf(1.0 / this.case + this.case * Math.log(a4 / a3) / 2.0);
            double a7 = a3 * a5.cdf(1.0 / this.case + this.case * Math.log(a3 / a4) / 2.0) * (a4 * a5.cdf(1.0 / this.case + this.case * Math.log(a4 / a3) / 2.0)) + this.case * (a3 * a5.density(1.0 / this.case + this.case * Math.log(a3 / a4) / 2.0)) / 2.0;
            double a8 = Math.log(a3);
            double a9 = Math.log(a4);
            double a10 = this.false.getShape() * a8 + this.new.getShape() * a9 - Math.log(this.false.getScale() * this.new.getScale());
            a2 = Math.log(a7) + a10 - a6;
        }
        return Math.exp(a2);
    }

    static {
        Package.validate("EVT");
        const = new BrentRoot(Constants.EPSILON, Integer.MAX_VALUE);
    }

    private double do(double a2, double a3) {
        BivariateEVDHuslerReiss a4;
        double a5 = -Math.log(a2);
        double a6 = -Math.log(a3);
        double a7 = 1.0 / a4.case;
        NormalDistribution a8 = new NormalDistribution();
        double a9 = a6 * a8.cdf(a7 + (Math.log(a6) - Math.log(a5)) * a4.case / 2.0) + a5 * a8.cdf(a7 + (Math.log(a5) - Math.log(a6)) * a4.case / 2.0);
        double a10 = a8.cdf(a7 + (Math.log(a6) - Math.log(a5)) * a4.case / 2.0) * Math.exp(-a9) / a3;
        return a10;
    }

    @Override
    public double conditionalCopula(double x1, double x2) {
        ArgumentAssertion.assertRangeOpen(x1, 0.0, 1.0, "x1");
        ArgumentAssertion.assertRangeOpen(x2, 0.0, 1.0, "x2");
        return this.do(x1, x2);
    }

    public BivariateEVDHuslerReiss(double dependence) {
        this(dependence, new GeneralizedEVD());
    }

    @Override
    public double[] nextVector() {
        double a2;
        final double[] a3 = new double[]{this.enum.nextDouble(), this.enum.nextDouble()};
        AbstractUnivariateRealFunction a4 = new AbstractUnivariateRealFunction(){

            @Override
            public double evaluate(double x) {
                return BivariateEVDHuslerReiss.this.do(x, a3[1]) - a3[0];
            }
            {
                1 a2;
            }
        };
        try {
            a2 = const.solve(a4, Constants.MACH_EPS, 1.0 - Constants.MACH_EPS, new double[0]);
        }
        catch (NoRootFoundException a5) {
            a2 = a5.x();
        }
        a3[0] = a2;
        double a6 = this.false.marginalInverseTransform(-Math.log(a3[0]));
        double a7 = this.new.marginalInverseTransform(-Math.log(a3[1]));
        return new double[]{a6, a7};
    }

    @Override
    public double dependence(double x) {
        ArgumentAssertion.assertRange(x, 0.0, 1.0, "x");
        double a2 = 1.0 - x;
        return x * new NormalDistribution().cdf(1.0 / this.case + this.case * Math.log(x / (1.0 - x)) / 2.0) + a2 * new NormalDistribution().cdf(1.0 / this.case + this.case * Math.log(a2 / (1.0 - a2)) / 2.0);
    }

    @Override
    public double cdf(double x1, double x2) {
        double a2 = this.false.marginalTransform(x1);
        double a3 = this.new.marginalTransform(x2);
        NormalDistribution a4 = new NormalDistribution();
        double a5 = a2 * a4.cdf(1.0 / this.case + this.case * Math.log(a2 / a3) / 2.0) + a3 * a4.cdf(1.0 / this.case + this.case * Math.log(a3 / a2) / 2.0);
        double a6 = Math.exp(-a5);
        return a6;
    }

    @Override
    public double spectralDensity(double x) {
        ArgumentAssertion.assertRange(x, 0.0, 1.0, "x");
        double a2 = this.case * new NormalDistribution().density(1.0 / this.case + this.case * Math.log(x / (1.0 - x)) / 2.0);
        return a2 /= 2.0 * x * (1.0 - x) * (1.0 - x);
    }
}

