/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.evt.evd.univariate;

import com.numericalmethod.suanshu.analysis.function.special.gamma.Gamma;
import com.numericalmethod.suanshu.analysis.function.special.gamma.GammaLanczosQuick;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.misc.license.Package;
import com.numericalmethod.suanshu.stats.evt.evd.univariate.UnivariateEVD;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class GeneralizedEVD
implements UnivariateEVD {
    private final double const;
    private final double case;
    private final double false;
    private static final Gamma enum;

    @Override
    public double logDensity(double x) {
        double a2 = (x - this.const) / this.false;
        if (this.case == 0.0) {
            return Math.log(1.0 / this.false) - a2 - Math.exp(-a2);
        }
        double a3 = a2 * this.case + 1.0;
        if (a3 > 0.0 || a3 == Double.NaN) {
            return Math.log(1.0 / this.false) - Math.pow(a3, -1.0 / this.case) - (1.0 / this.case + 1.0) * Math.log(a3);
        }
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public double variance() {
        if (this.case == 0.0) {
            return this.false * this.false * (Math.PI * Math.PI) / 6.0;
        }
        if (this.case < 0.5) {
            double a2 = this.false / this.case;
            double a3 = this.do(1);
            double a4 = this.do(2);
            return a2 * a2 * (a4 - a3 * a3);
        }
        return Double.POSITIVE_INFINITY;
    }

    public GeneralizedEVD() {
        this(0.0, 1.0, 0.0);
    }

    @Override
    public double quantile(double p) {
        ArgumentAssertion.assertRangeOpen(p, 0.0, 1.0, "probability p");
        return this.marginalInverseTransform(-Math.log(p));
    }

    public double marginalInverseTransform(double x) {
        if (this.case != 0.0) {
            return (Math.pow(x, -this.case) - 1.0) / this.case * this.false + this.const;
        }
        return this.const - this.false * Math.log(x);
    }

    @Override
    public double kurtosis() {
        if (this.case == 0.0) {
            return 2.4;
        }
        double a2 = this.do(1);
        double a3 = this.do(2);
        double a4 = this.do(3);
        double a5 = this.do(4);
        double a6 = a2 * a2;
        double a7 = a6 * a6;
        return (a5 - 4.0 * a2 * a4 + 6.0 * a3 * a6 - 3.0 * a7) / (a3 - a6) / (a3 - a6) - 3.0;
    }

    public double getScale() {
        return this.false;
    }

    public double getLocation() {
        return this.const;
    }

    public double getShape() {
        return this.case;
    }

    @Override
    public double moment(double x) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double density(double x) {
        return Math.exp(this.logDensity(x));
    }

    @Override
    public double mean() {
        if (this.case == 0.0) {
            return this.const + this.false * 0.5772156649015329;
        }
        if (this.case < 1.0) {
            return this.const + this.false * (this.do(1) - 1.0) / this.case;
        }
        return Double.POSITIVE_INFINITY;
    }

    private double do(int a2) {
        GeneralizedEVD a3;
        return enum.evaluate(1.0 - (double)a2 * a3.case);
    }

    private boolean do(double a2) {
        GeneralizedEVD a3;
        return 1.0 + a3.case * (a2 - a3.const) / a3.false > 0.0;
    }

    @Override
    public double entropy() {
        double a2 = 0.5772156649015329;
        return Math.log(this.false) + a2 * this.case + (a2 + 1.0);
    }

    static {
        Package.validate("EVT");
        enum = new GammaLanczosQuick();
    }

    public double marginalTransform(double x) {
        if (this.case != 0.0) {
            return Math.pow(Math.max(1.0 + this.case * (x - this.const) / this.false, 0.0), -1.0 / this.case);
        }
        return Math.exp(-(x - this.const) / this.false);
    }

    @Override
    public double skew() {
        if (this.case == 0.0) {
            return 12.0 * Math.sqrt(6.0) * 1.2020569031595942 / Math.pow(Math.PI, 3.0);
        }
        double a2 = this.do(1);
        double a3 = this.do(2);
        double a4 = this.do(3);
        return (a4 - 3.0 * a2 * a3 + 2.0 * a2 * a2 * a2) / Math.pow(a3 - a2 * a2, 1.5);
    }

    @Override
    public double cdf(double x) {
        if (!this.do(x)) {
            return 0.0;
        }
        return Math.exp(-this.marginalTransform(x));
    }

    @Override
    public double median() {
        if (this.case == 0.0) {
            return this.const - this.false * Math.log(Math.log(2.0));
        }
        return this.const + this.false * (Math.pow(Math.log(2.0), -this.case) - 1.0) / this.case;
    }

    public GeneralizedEVD(double location, double scale, double shape) {
        ArgumentAssertion.assertPositive(scale, "scale");
        this.const = location;
        this.false = scale;
        this.case = shape;
    }
}

