/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.evt.evd.univariate;

import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.misc.license.Package;
import com.numericalmethod.suanshu.stats.evt.evd.univariate.UnivariateEVD;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class GeneralizedParetoDistribution
implements UnivariateEVD {
    private final double case;
    private final double false;
    private final double enum;

    @Override
    public double variance() {
        if (this.case < 0.5) {
            double a2 = 1.0 - this.case;
            double a3 = a2 - this.case;
            return this.false * this.false / (a2 * a2 * a3);
        }
        throw new RuntimeException("variance only exists if shape < 0.5");
    }

    public GeneralizedParetoDistribution() {
        this(0.0, 1.0, 0.0);
    }

    @Override
    public double entropy() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double median() {
        return this.enum + this.false * (Math.pow(2.0, this.case) - 1.0) / this.case;
    }

    public GeneralizedParetoDistribution(double location, double scale, double shape) {
        ArgumentAssertion.assertPositive(scale, "scale");
        this.enum = location;
        this.false = scale;
        this.case = shape;
    }

    @Override
    public double logDensity(double x) {
        boolean a2;
        double a3 = (x - this.enum) / this.false;
        boolean bl = a2 = a3 > 0.0 && 1.0 + this.case * a3 > 0.0 || a3 == Double.NaN;
        if (!a2) {
            return Double.NEGATIVE_INFINITY;
        }
        if (this.case == 0.0) {
            return Math.log(1.0 / this.false) - a3;
        }
        return Math.log(1.0 / this.false) - (1.0 + 1.0 / this.case) * Math.log(1.0 + this.case * a3);
    }

    @Override
    public double skew() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public GeneralizedParetoDistribution(double scale, double shape) {
        this(0.0, scale, shape);
    }

    @Override
    public double kurtosis() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    static {
        Package.validate("EVT");
    }

    @Override
    public double cdf(double x) {
        if (x < this.enum) {
            return 0.0;
        }
        double a2 = (x - this.enum) / this.false;
        if (this.case == 0.0) {
            return 1.0 - Math.exp(-a2);
        }
        double a3 = 1.0 + this.case * a2;
        if (this.case < 0.0 && a3 < 0.0) {
            return 1.0;
        }
        return 1.0 - Math.pow(a3, -1.0 / this.case);
    }

    @Override
    public double density(double x) {
        return Math.exp(this.logDensity(x));
    }

    @Override
    public double moment(double x) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double mean() {
        if (this.case < 1.0) {
            return this.enum + this.false / (1.0 - this.case);
        }
        throw new RuntimeException("mean only exists if shape < 1");
    }

    @Override
    public double quantile(double p) {
        ArgumentAssertion.assertRangeOpen(p, 0.0, 1.0, "probability p");
        if (this.case == 0.0) {
            return this.enum - this.false * Math.log(1.0 - p);
        }
        return this.enum + this.false * (Math.pow(1.0 - p, -this.case) - 1.0) / this.case;
    }
}

