/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.evt.evd.univariate;

import com.numericalmethod.suanshu.analysis.function.special.beta.BetaRegularized;
import com.numericalmethod.suanshu.analysis.function.special.beta.BetaRegularizedInverse;
import com.numericalmethod.suanshu.analysis.function.special.beta.LogBeta;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.misc.license.Package;
import com.numericalmethod.suanshu.stats.distribution.univariate.ProbabilityDistribution;
import com.numericalmethod.suanshu.stats.evt.evd.univariate.UnivariateEVD;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class OrderStatisticsDistribution
implements UnivariateEVD {
    private final ProbabilityDistribution case;
    private final int false;
    private final int enum;

    @Override
    public double kurtosis() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double density(double x) {
        return Math.exp(this.logDensity(x));
    }

    @Override
    public double moment(double x) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    static {
        Package.validate("EVT");
    }

    @Override
    public double quantile(double x) {
        BetaRegularizedInverse a2 = new BetaRegularizedInverse(this.enum, this.false - this.enum + 1);
        return this.case.quantile(a2.evaluate(x));
    }

    @Override
    public double mean() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public OrderStatisticsDistribution(ProbabilityDistribution dist, int nIIDs, int order) {
        ArgumentAssertion.assertPositive(nIIDs, "number of independent variables");
        ArgumentAssertion.assertPositive(order, "order");
        ArgumentAssertion.assertTrue(order <= nIIDs, "order (%d) cannot be greater than nIIDs (%d)", order, nIIDs);
        this.case = dist;
        this.false = nIIDs;
        this.enum = order;
    }

    @Override
    public double logDensity(double x) {
        double a2 = Math.log(this.case.density(x));
        if (Double.isInfinite(a2)) {
            return Double.NEGATIVE_INFINITY;
        }
        double a3 = this.case.cdf(x);
        double a4 = (double)(this.enum - 1) * Math.log(a3) + (double)(this.false - this.enum) * Math.log(1.0 - a3);
        double a5 = new LogBeta().evaluate(this.enum, this.false - this.enum + 1);
        double a6 = a2 + a4 - a5;
        return a6;
    }

    @Override
    public double median() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double skew() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double cdf(double x) {
        double a2 = this.case.cdf(x);
        BetaRegularized a3 = new BetaRegularized(this.enum, this.false - this.enum + 1);
        return a3.evaluate(a2);
    }

    @Override
    public double variance() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double entropy() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

