/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.evt.evd.univariate.fitting;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.operation.Inverse;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.ImmutableVector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.operation.VectorFactory;
import com.numericalmethod.suanshu.analysis.differentiation.multivariate.Hessian;
import com.numericalmethod.suanshu.analysis.function.rn2r1.RealScalarFunction;
import com.numericalmethod.suanshu.misc.license.Package;
import com.numericalmethod.suanshu.stats.distribution.univariate.NormalDistribution;
import com.numericalmethod.suanshu.stats.evt.evd.univariate.fitting.ConfidenceInterval;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class EstimateByLogLikelihood {
    private final RealScalarFunction false;
    private final ImmutableVector enum;

    public Matrix covarianceMatrix() {
        Hessian a2 = new Hessian(this.false, this.enum);
        Inverse a3 = new Inverse(a2.opposite());
        return a3;
    }

    public RealScalarFunction getLogLikelihoodFunction() {
        return this.false;
    }

    static {
        Package.validate("EVT");
    }

    public ConfidenceInterval confidenceInterval(double confidenceLevel) {
        NormalDistribution a2 = new NormalDistribution();
        double a3 = a2.quantile(0.5 + 0.5 * confidenceLevel);
        Vector a4 = this.standardError().scaled(a3);
        Vector a5 = this.enum.minus(a4);
        Vector a6 = this.enum.add(a4);
        return new ConfidenceInterval(confidenceLevel, this.enum, a5, a6);
    }

    public double logLikelihood() {
        return (Double)this.false.evaluate(this.enum);
    }

    public ImmutableVector getFittedParameters() {
        return this.enum;
    }

    public EstimateByLogLikelihood(Vector fittedParameters, RealScalarFunction logLikelihoodFunction) {
        this.enum = new ImmutableVector(fittedParameters);
        this.false = logLikelihoodFunction;
    }

    public Vector standardError() {
        Matrix a2 = this.covarianceMatrix();
        return VectorFactory.diagonal(a2).pow(0.5);
    }
}

