/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.evt.evd.univariate.fitting.acer;

import com.numericalmethod.suanshu.misc.license.Package;
import com.numericalmethod.suanshu.stats.evt.evd.univariate.fitting.acer.ACERConfidenceInterval;
import com.numericalmethod.suanshu.stats.evt.evd.univariate.fitting.acer.ACERFunction;
import com.numericalmethod.suanshu.stats.evt.evd.univariate.fitting.acer.ACERReturnLevel;
import com.numericalmethod.suanshu.stats.evt.evd.univariate.fitting.acer.NonlinearFit;
import com.numericalmethod.suanshu.stats.evt.evd.univariate.fitting.acer.empirical.EmpiricalACER;
import com.numericalmethod.suanshu.stats.evt.evd.univariate.fitting.acer.empirical.EmpiricalACEREstimation;
import com.numericalmethod.suanshu.stats.evt.evd.univariate.fitting.acer.empirical.EpsilonStatisticsCalculator;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ACERAnalysis {
    private final boolean new;
    private final double const;
    private final int case;
    private final boolean false;
    private final int enum;

    public Result run(double[][] observations, double tailMarker) {
        EmpiricalACEREstimation a2 = new EmpiricalACEREstimation(this.enum, this.false, new EpsilonStatisticsCalculator(this.new, this.const), this.case);
        EmpiricalACER a3 = a2.estimate(observations);
        NonlinearFit.Result a4 = new NonlinearFit().fit(a3, tailMarker);
        ACERFunction.ACERParameter a5 = a4.getParameter();
        ACERReturnLevel a6 = new ACERReturnLevel(a5, a3.getEventCountPerPeriod());
        ACERConfidenceInterval a7 = new ACERConfidenceInterval(a5, a3, a3.getEventCountPerPeriod(), tailMarker);
        return new Result(a4, a7, a6, a3);
    }

    public Result run(double[] observations, double tailMarker) {
        return this.run(new double[][]{observations}, tailMarker);
    }

    static {
        Package.validate("EVT");
    }

    public ACERAnalysis() {
        this(2, 300, 0.95, true, true);
    }

    public ACERAnalysis(int kStepMemory, int nLevels, double confidenceLevel, boolean usePeaksOnly, boolean weightedByPeakCount) {
        this.case = kStepMemory;
        this.enum = nLevels;
        this.const = confidenceLevel;
        this.false = usePeaksOnly;
        this.new = weightedByPeakCount;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Result {
        private final EmpiricalACER const;
        private final ACERReturnLevel case;
        private final ACERConfidenceInterval false;
        private final NonlinearFit.Result enum;

        public NonlinearFit.Result getFitResult() {
            return this.enum;
        }

        public ACERConfidenceInterval getConfidenceInterval() {
            return this.false;
        }

        public EmpiricalACER getEstimates() {
            return this.const;
        }

        public Result(NonlinearFit.Result fitResult, ACERConfidenceInterval confidenceInterval, ACERReturnLevel returnLevel, EmpiricalACER estimates) {
            this.enum = fitResult;
            this.false = confidenceInterval;
            this.case = returnLevel;
            this.const = estimates;
        }

        public ACERReturnLevel getReturnLevel() {
            return this.case;
        }
    }
}

