/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.evt.evd.univariate.fitting.acer.empirical;

import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.misc.license.Package;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.number.doublearray.DoubleArrayMath;
import com.numericalmethod.suanshu.stats.descriptive.moment.Mean;
import com.numericalmethod.suanshu.stats.evt.evd.univariate.fitting.acer.empirical.ACERByCounting;
import com.numericalmethod.suanshu.stats.evt.evd.univariate.fitting.acer.empirical.ACERUtils;
import com.numericalmethod.suanshu.stats.evt.evd.univariate.fitting.acer.empirical.EmpiricalACER;
import com.numericalmethod.suanshu.stats.evt.evd.univariate.fitting.acer.empirical.EmpiricalACERStatistics;
import com.numericalmethod.suanshu.stats.evt.evd.univariate.fitting.acer.empirical.EpsilonStatisticsCalculator;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class EmpiricalACEREstimation {
    private final int const;
    private final int case;
    private final EpsilonStatisticsCalculator false;
    private final boolean enum;

    static {
        Package.validate("EVT");
    }

    private static double[][] do(double[][] a2) {
        double[][] a3 = new double[a2.length][];
        for (int a4 = 0; a4 < a2.length; ++a4) {
            a3[a4] = ACERUtils.extractPeaks(a2[a4]);
        }
        return a3;
    }

    public EmpiricalACEREstimation() {
        this(300, true, new EpsilonStatisticsCalculator(true, 0.95), 2);
    }

    public EmpiricalACER estimate(double[][] observations) {
        double[][] a2 = this.enum ? EmpiricalACEREstimation.do(observations) : observations;
        double[] a3 = DoubleUtils.concat(a2);
        int a4 = a3.length;
        int a5 = observations.length;
        double a6 = DoubleArrayMath.min(a3);
        double a7 = DoubleArrayMath.max(a3);
        double a8 = (a7 - a6) / (double)(this.case - 1);
        double[] a9 = DoubleUtils.seq(a6, a7, a8);
        ACERByCounting a10 = new ACERByCounting(a9, this.const);
        double[][] a11 = a10.estimateForMultiPeriods(observations);
        EmpiricalACERStatistics a12 = this.false.compute(a2, a11, this.const);
        double a13 = new Mean(a3).value();
        double a14 = (double)a4 / (double)a5;
        EmpiricalACER a15 = new EmpiricalACER(a2, a9, a14, a13, a11, a12.getMean(), a12.getConfidenceInterval());
        return a15;
    }

    public EmpiricalACEREstimation(int nLevels, boolean usePeaksOnly, EpsilonStatisticsCalculator statisticsCalculator, int kStepMemory) {
        ArgumentAssertion.assertPositive(kStepMemory, "k");
        this.case = nLevels;
        this.enum = usePeaksOnly;
        this.false = statisticsCalculator;
        this.const = kStepMemory;
    }
}

