/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.evt.evd.univariate.fitting.acer.empirical;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.dense.DenseVector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.operation.VectorFactory;
import com.numericalmethod.suanshu.analysis.function.rn2r1.AbstractRealScalarFunction;
import com.numericalmethod.suanshu.analysis.function.rn2r1.univariate.AbstractUnivariateRealFunction;
import com.numericalmethod.suanshu.analysis.function.rn2r1.univariate.UnivariateRealFunction;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.stats.descriptive.moment.Variance;
import com.numericalmethod.suanshu.stats.descriptive.moment.weighted.WeightedVariance;
import com.numericalmethod.suanshu.stats.distribution.univariate.NormalDistribution;
import com.numericalmethod.suanshu.stats.distribution.univariate.TDistribution;
import com.numericalmethod.suanshu.stats.evt.evd.univariate.fitting.acer.empirical.ACERUtils;
import com.numericalmethod.suanshu.stats.evt.evd.univariate.fitting.acer.empirical.EmpiricalACERStatistics;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class EpsilonStatisticsCalculator {
    private final boolean case;
    private static final UnivariateRealFunction false = new AbstractUnivariateRealFunction(){
        {
            1 a2;
        }

        @Override
        public double evaluate(double x) {
            return Math.sqrt(x);
        }
    };
    private final double enum;

    private EmpiricalACERStatistics do(Matrix a2, final double[] a3) {
        EpsilonStatisticsCalculator a4;
        Vector a5 = a2.multiply(new DenseVector(a3));
        int a6 = a2.nCols();
        Vector a7 = VectorFactory.foreachRow(a2, new AbstractRealScalarFunction(a6){
            {
                2 a32;
                super(a2);
            }

            @Override
            public Double evaluate(Vector x) {
                return new WeightedVariance(x.toArray(), a3).stdev();
            }
        });
        Vector a8 = a4.do(a7, a6);
        return new EmpiricalACERStatistics(a5.toArray(), a8.toArray());
    }

    public EpsilonStatisticsCalculator(boolean isWeightedByPeakCount, double confidenceLevel) {
        ArgumentAssertion.assertRangeOpen(confidenceLevel, 0.0, 1.0, "confidence level");
        this.case = isWeightedByPeakCount;
        this.enum = confidenceLevel;
    }

    private EmpiricalACERStatistics do(int a2, int a3, Matrix a4) {
        EpsilonStatisticsCalculator a5;
        Vector a6 = a4.getColumn(1);
        NormalDistribution a7 = new NormalDistribution();
        double a8 = a7.quantile((1.0 + a5.enum) / 2.0);
        double a9 = Math.sqrt(a2 - a3 + 1);
        Vector a10 = VectorFactory.foreach(a6, false).scaled(a8 / a9);
        return new EmpiricalACERStatistics(a6.toArray(), a10.toArray());
    }

    private EmpiricalACERStatistics do(Matrix a2) {
        EpsilonStatisticsCalculator a3;
        int a4 = a2.nCols();
        Vector a5 = a2.multiply(new DenseVector(a4, 1.0 / (double)a4));
        Vector a6 = VectorFactory.foreachRow(a2, new AbstractRealScalarFunction(a4){

            @Override
            public Double evaluate(Vector x) {
                return new Variance(x.toArray()).standardDeviation();
            }
            {
                3 a3;
                super(a2);
            }
        });
        Vector a7 = a3.do(a6, a4);
        return new EmpiricalACERStatistics(a5.toArray(), a7.toArray());
    }

    private Vector do(Vector a2, int a3) {
        EpsilonStatisticsCalculator a4;
        TDistribution a5 = new TDistribution(a3 - 1);
        double a6 = a5.quantile((1.0 + a4.enum) / 2.0);
        double a7 = Math.sqrt(a3);
        return a2.scaled(a6 / a7);
    }

    public EmpiricalACERStatistics compute(double[][] observations, double[][] acers, int kStepMemory) {
        DenseMatrix a2 = new DenseMatrix(acers).t();
        if (a2.nCols() > 1) {
            if (this.case) {
                double[] a3 = ACERUtils.computeWeightsByPeriodLength(observations);
                return this.do(a2, a3);
            }
            return this.do(a2);
        }
        return this.do(observations[0].length, kStepMemory, a2);
    }
}

