/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.factoranalysis;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.ImmutableMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.eigen.Eigen;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.svd.SVD;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.diagonal.DiagonalMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.operation.Inverse;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.operation.MatrixUtils;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.dense.DenseVector;
import com.numericalmethod.suanshu.analysis.function.rn2r1.univariate.AbstractUnivariateRealFunction;
import com.numericalmethod.suanshu.misc.PrecisionUtils;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.number.doublearray.DoubleArrayMath;
import com.numericalmethod.suanshu.stats.descriptive.correlation.CorrelationMatrix;
import com.numericalmethod.suanshu.stats.descriptive.covariance.SampleCovariance;
import com.numericalmethod.suanshu.stats.descriptive.moment.Variance;
import com.numericalmethod.suanshu.stats.factoranalysis.FAEstimator;
import com.numericalmethod.suanshu.stats.factoranalysis.FactorAnalysisMLE;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FactorAnalysis {
    private final ScoringRule const;
    private final ImmutableMatrix case;
    private final int false;
    private final ImmutableMatrix enum;

    public FactorAnalysis(Matrix data, int nFactors) {
        this(data, nFactors, ScoringRule.BARTLETT, new CorrelationMatrix((Matrix)new SampleCovariance(data)));
    }

    public ScoringRule scoringRule() {
        return this.const;
    }

    public FactorAnalysis(Matrix data, int nFactors, ScoringRule rule) {
        this(data, nFactors, rule, new CorrelationMatrix((Matrix)new SampleCovariance(data)));
    }

    public FactorAnalysis(Matrix data, int nFactors, ScoringRule rule, Matrix S) {
        this.enum = new ImmutableMatrix(data);
        this.false = nFactors;
        this.const = rule;
        this.case = new ImmutableMatrix(S);
    }

    public int nObs() {
        return this.enum.nRows();
    }

    static Matrix getVarimaxRotation(Matrix a2, boolean a3, double a4) {
        int a5 = a2.nRows();
        int a6 = a2.nCols();
        if (a6 < 2) {
            return new DenseMatrix(new double[]{1.0}, 1, 1);
        }
        DenseMatrix a7 = new DenseMatrix(a2);
        double[] a8 = DoubleUtils.rep(1.0, a5);
        if (a3) {
            for (int a9 = 1; a9 <= a5; ++a9) {
                a8[a9 - 1] = a7.getRow(a9).norm();
                a7.setRow(a9, a7.getRow(a9).scaled(1.0 / a8[a9 - 1]));
            }
        }
        Matrix a10 = new DiagonalMatrix(DoubleUtils.rep(1.0, a6));
        double a11 = 0.0;
        double a12 = 0.0;
        while (true) {
            int a13;
            Matrix a14 = a7.multiply(a10);
            DenseMatrix a15 = new DenseMatrix(a5, a6);
            for (int a16 = 1; a16 <= a5; ++a16) {
                for (a13 = 1; a13 <= a6; ++a13) {
                    a15.set(a16, a13, a14.get(a16, a13) * a14.get(a16, a13) * a14.get(a16, a13));
                }
            }
            double[] a17 = new double[a6];
            for (a13 = 0; a13 < a6; ++a13) {
                a17[a13] = a14.getColumn(a13 + 1).norm();
                int n = a13;
                a17[n] = a17[n] * a17[a13];
            }
            DiagonalMatrix a18 = new DiagonalMatrix(a17);
            Matrix a19 = a7.t().multiply(a15.minus(a14.multiply(a18).scaled(1.0 / (double)a5)));
            SVD a20 = new SVD(a19, true);
            a10 = a20.U().multiply(a20.V().t());
            a12 = DoubleArrayMath.sum(MatrixUtils.to1DArray(a20.D()));
            if (a12 < a11 * (1.0 + a4)) break;
            a11 = a12;
        }
        return a10;
    }

    static Matrix getLoadings(Vector a2, int a3, Matrix a4) {
        int a5 = a4.nRows();
        double[] a6 = a2.toArray();
        DiagonalMatrix a7 = new DiagonalMatrix(DoubleUtils.foreach(a6, new AbstractUnivariateRealFunction(){

            @Override
            public double evaluate(double psi) {
                return Math.sqrt(psi);
            }
            {
                1 a2;
            }
        }));
        DiagonalMatrix a8 = new DiagonalMatrix(DoubleUtils.foreach(a6, new AbstractUnivariateRealFunction(){
            {
                2 a2;
            }

            @Override
            public double evaluate(double psi) {
                return 1.0 / Math.sqrt(psi);
            }
        }));
        Matrix a9 = a8.multiply(a4).multiply(a8);
        Eigen a10 = new Eigen(a9, Eigen.Method.QR_SYMMETRIC);
        double[] a11 = Arrays.copyOfRange(a10.getRealEigenvalues(), 0, a3);
        DiagonalMatrix a12 = new DiagonalMatrix(DoubleUtils.foreach(a11, new AbstractUnivariateRealFunction(){
            {
                3 a2;
            }

            @Override
            public double evaluate(double theta) {
                return Math.sqrt(Math.max(theta - 1.0, 0.0));
            }
        }));
        DenseMatrix a13 = new DenseMatrix(a5, a3);
        for (int a14 = 1; a14 <= a3; ++a14) {
            a13.setColumn(a14, a10.getProperty(a14 - 1).eigenVector());
        }
        Matrix a15 = a7.multiply(a13).multiply(a12);
        return a15;
    }

    public int nVariables() {
        return this.case.nRows();
    }

    private Matrix do(Matrix a2, Matrix a3, Vector a4, Matrix a5, ScoringRule a6) {
        Matrix a7;
        Object a8;
        int a9 = a2.nCols();
        DenseMatrix a10 = new DenseMatrix(a2);
        for (int a11 = 1; a11 <= a9; ++a11) {
            a8 = a10.getColumn(a11).toArray();
            Variance a12 = new Variance((double[])a8);
            double a13 = a12.mean();
            double a14 = a12.standardDeviation();
            a10.setColumn(a11, a10.getColumn(a11).minus(a13).scaled(1.0 / a14));
        }
        switch (a6) {
            case THOMSON: {
                a8 = new Inverse(a3).multiply(a5);
                a7 = a10.multiply((Matrix)a8);
                break;
            }
            case BARTLETT: {
                a8 = new DenseMatrix(a5.nRows(), a5.nCols());
                for (int a15 = 1; a15 <= a5.nRows(); ++a15) {
                    for (int a16 = 1; a16 <= a5.nCols(); ++a16) {
                        ((DenseMatrix)a8).set(a15, a16, a5.get(a15, a16) / a4.get(a15));
                    }
                }
                a8 = ((DenseMatrix)a8).t();
                a7 = new Inverse(((DenseMatrix)a8).multiply(a5)).multiply(((DenseMatrix)a8).multiply(a10.t())).t();
                break;
            }
            default: {
                throw new UnsupportedOperationException("");
            }
        }
        return a7;
    }

    public FAEstimator getEstimators(int maxIterations) {
        int a2 = this.nVariables();
        double a3 = 1.0 - 0.5 * (double)this.false / (double)a2;
        Inverse a4 = new Inverse(this.case);
        DenseVector a5 = new DenseVector(a2);
        for (int a6 = 1; a6 <= a2; ++a6) {
            a5.set(a6, a3 / a4.get(a6, a6));
        }
        return this.getEstimators(a5, maxIterations);
    }

    static Matrix getRotatedLoadings(Matrix a2, boolean a3, double a4) {
        if (a2.nCols() < 2) {
            return a2;
        }
        Matrix a5 = FactorAnalysis.getVarimaxRotation(a2, a3, a4);
        return a2.multiply(a5);
    }

    public int nFactors() {
        return this.false;
    }

    public FAEstimator getEstimators(Vector initial, int maxIterations) {
        FactorAnalysisMLE a2 = new FactorAnalysisMLE(this.S(), this.false, FactorAnalysisMLE.Gradient.NUMERICAL, PrecisionUtils.autoEpsilon(this.case), maxIterations);
        Vector a3 = a2.estimate(initial);
        Matrix a4 = FactorAnalysis.getLoadings(a3, this.false, this.case);
        Matrix a5 = FactorAnalysis.getRotatedLoadings(a4, true, 1.0E-5);
        for (int a6 = 1; a6 <= a5.nCols(); ++a6) {
            double a7 = 0.0;
            for (int a8 = 1; a8 <= a5.nRows(); ++a8) {
                a7 += a5.get(a8, a6);
            }
            if (!(a7 < 0.0)) continue;
            ((DenseMatrix)a5).setColumn(a6, a5.getColumn(a6).scaled(-1.0));
        }
        double a9 = (Double)a2.nL.evaluate(a3);
        int a10 = this.nVariables() - this.false;
        a10 *= a10;
        a10 -= this.nVariables() + this.false;
        Matrix a11 = this.do(this.enum, this.case, a3, a5, this.const);
        return new FAEstimator(this.nObs(), a3, a5, a9, a10 /= 2, a11);
    }

    public ImmutableMatrix S() {
        return this.case;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static enum ScoringRule {
        THOMSON,
        BARTLETT;


        private ScoringRule() {
            ScoringRule a2;
        }
    }
}

