/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.hmm.mixture.distribution;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.stats.distribution.univariate.BinomialDistribution;
import com.numericalmethod.suanshu.stats.distribution.univariate.ProbabilityDistribution;
import com.numericalmethod.suanshu.stats.hmm.mixture.distribution.MixtureDistribution;
import com.numericalmethod.suanshu.stats.random.rng.univariate.BinomialRNG;
import com.numericalmethod.suanshu.stats.random.rng.univariate.RandomNumberGenerator;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MixtureBinomialDistribution
implements MixtureDistribution {
    private final Lambda[] enum;

    @Override
    public ProbabilityDistribution[] getDistributions() {
        ProbabilityDistribution[] a2 = new ProbabilityDistribution[this.enum.length];
        for (int a3 = 0; a3 < this.enum.length; ++a3) {
            int a4 = this.enum[a3].size;
            double a5 = this.enum[a3].p;
            a2[a3] = new BinomialDistribution(a4, a5);
        }
        return a2;
    }

    public Lambda[] getMStepParams(double[] observations, Matrix u, Object[] param0) {
        Lambda[] a2 = Arrays.copyOf((Lambda[])param0, param0.length);
        int a3 = u.nRows();
        int a4 = u.nCols();
        Lambda[] a5 = new Lambda[a2.length];
        for (int a6 = 0; a6 < a4; ++a6) {
            int a7 = a2[a6].size;
            double a8 = 0.0;
            double a9 = 0.0;
            for (int a10 = 0; a10 < a3; ++a10) {
                double a11 = u.get(a10 + 1, a6 + 1);
                a8 += a11 * observations[a10];
                a9 += a11 * (double)a7;
            }
            double a12 = a8 / a9;
            a5[a6] = new Lambda(a7, a12);
        }
        return a5;
    }

    @Override
    public RandomNumberGenerator[] getRandomNumberGenerators() {
        RandomNumberGenerator[] a2 = new RandomNumberGenerator[this.enum.length];
        for (int a3 = 0; a3 < this.enum.length; ++a3) {
            int a4 = this.enum[a3].size;
            double a5 = this.enum[a3].p;
            a2[a3] = new BinomialRNG(a4, a5);
        }
        return a2;
    }

    @Override
    public MixtureDistribution newEMDistribution(Object[] param) {
        Lambda[] a2 = Arrays.copyOf((Lambda[])param, param.length);
        return new MixtureBinomialDistribution(a2);
    }

    public MixtureBinomialDistribution(Lambda[] lambda) {
        this.enum = Arrays.copyOf(lambda, lambda.length);
    }

    public Lambda[] getParams() {
        Lambda[] a2 = Arrays.copyOf(this.enum, this.enum.length);
        return a2;
    }

    public static class Lambda {
        public final int size;
        public final double p;

        public Lambda(int size, double p) {
            this.size = size;
            this.p = p;
        }
    }
}

