/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.hmm.mixture.distribution;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.analysis.function.rn2r1.univariate.AbstractUnivariateRealFunction;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.stats.distribution.univariate.LogNormalDistribution;
import com.numericalmethod.suanshu.stats.distribution.univariate.ProbabilityDistribution;
import com.numericalmethod.suanshu.stats.hmm.mixture.distribution.MixtureDistribution;
import com.numericalmethod.suanshu.stats.random.rng.univariate.LogNormalRNG;
import com.numericalmethod.suanshu.stats.random.rng.univariate.RandomNumberGenerator;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MixtureLogNormalDistribution
implements MixtureDistribution {
    private final boolean case;
    private final boolean false;
    private final Lambda[] enum;

    public MixtureLogNormalDistribution(Lambda[] lambda, boolean isMuEstimated, boolean isSigmaEstimated) {
        this.enum = Arrays.copyOf(lambda, lambda.length);
        this.case = isMuEstimated;
        this.false = isSigmaEstimated;
    }

    public Lambda[] getParams() {
        Lambda[] a2 = Arrays.copyOf(this.enum, this.enum.length);
        return a2;
    }

    @Override
    public MixtureDistribution newEMDistribution(Object[] param) {
        Lambda[] a2 = Arrays.copyOf((Lambda[])param, param.length);
        return new MixtureLogNormalDistribution(a2, this.case, this.false);
    }

    public MixtureLogNormalDistribution(Lambda[] lambda) {
        this(lambda, true, true);
    }

    public Lambda[] getMStepParams(double[] observations, Matrix u, Object[] param0) {
        Lambda[] a2 = Arrays.copyOf((Lambda[])param0, param0.length);
        int a3 = u.nRows();
        int a4 = u.nCols();
        double[] a5 = DoubleUtils.foreach(observations, new AbstractUnivariateRealFunction(){
            {
                1 a2;
            }

            @Override
            public double evaluate(double x) {
                return Math.log(x);
            }
        });
        Lambda[] a6 = new Lambda[a2.length];
        for (int a7 = 1; a7 <= a4; ++a7) {
            double a8;
            double a9;
            double a10 = this.enum[a7 - 1].logMu;
            if (this.case) {
                a9 = 0.0;
                a8 = 0.0;
                for (int a11 = 1; a11 <= a3; ++a11) {
                    double a12 = u.get(a11, a7);
                    a9 += a12 * a5[a11 - 1];
                    a8 += a12;
                }
                a10 = a9 / a8;
            }
            a9 = this.enum[a7 - 1].logSigma;
            if (this.false) {
                a8 = 0.0;
                double a13 = 0.0;
                for (int a14 = 1; a14 <= a3; ++a14) {
                    double a15 = u.get(a14, a7);
                    double a16 = a5[a14 - 1] - a10;
                    a8 += a15 * a16 * a16;
                    a13 += a15;
                }
                a9 = Math.sqrt(a8 / a13);
            }
            a6[a7 - 1] = new Lambda(a10, a9);
        }
        return a6;
    }

    @Override
    public RandomNumberGenerator[] getRandomNumberGenerators() {
        RandomNumberGenerator[] a2 = new RandomNumberGenerator[this.enum.length];
        for (int a3 = 0; a3 < this.enum.length; ++a3) {
            double a4 = this.enum[a3].logMu;
            double a5 = this.enum[a3].logSigma;
            a2[a3] = new LogNormalRNG(a4, a5);
        }
        return a2;
    }

    @Override
    public ProbabilityDistribution[] getDistributions() {
        ProbabilityDistribution[] a2 = new ProbabilityDistribution[this.enum.length];
        for (int a3 = 0; a3 < this.enum.length; ++a3) {
            double a4 = this.enum[a3].logMu;
            double a5 = this.enum[a3].logSigma;
            a2[a3] = new LogNormalDistribution(a4, a5);
        }
        return a2;
    }

    public static class Lambda {
        public final double logSigma;
        public final double logMu;

        public Lambda(double mu, double sigma) {
            this.logMu = mu;
            this.logSigma = sigma;
        }
    }
}

