/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.hmm.mixture.distribution;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.stats.distribution.univariate.PoissonDistribution;
import com.numericalmethod.suanshu.stats.distribution.univariate.ProbabilityDistribution;
import com.numericalmethod.suanshu.stats.hmm.mixture.distribution.MixtureDistribution;
import com.numericalmethod.suanshu.stats.random.rng.univariate.RandomNumberGenerator;
import com.numericalmethod.suanshu.stats.random.rng.univariate.poisson.Knuth1969;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MixturePoissonDistribution
implements MixtureDistribution {
    private final Double[] enum;

    @Override
    public ProbabilityDistribution[] getDistributions() {
        ProbabilityDistribution[] a2 = new ProbabilityDistribution[this.enum.length];
        for (int a3 = 0; a3 < this.enum.length; ++a3) {
            double a4 = this.enum[a3];
            a2[a3] = new PoissonDistribution(a4);
        }
        return a2;
    }

    public Double[] getMStepParams(double[] observations, Matrix u, Object[] param0) {
        int a2 = u.nRows();
        int a3 = u.nCols();
        Double[] a4 = new Double[param0.length];
        for (int a5 = 1; a5 <= a3; ++a5) {
            double a6 = 0.0;
            double a7 = 0.0;
            for (int a8 = 1; a8 <= a2; ++a8) {
                double a9 = u.get(a8, a5);
                a6 += a9 * observations[a8 - 1];
                a7 += a9;
            }
            a4[a5 - 1] = a6 / a7;
        }
        return a4;
    }

    public MixturePoissonDistribution(Double[] rates) {
        this.enum = Arrays.copyOf(rates, rates.length);
    }

    public Double[] getParams() {
        Double[] a2 = Arrays.copyOf(this.enum, this.enum.length);
        return a2;
    }

    @Override
    public MixtureDistribution newEMDistribution(Object[] param) {
        Double[] a2 = Arrays.copyOf((Double[])param, param.length);
        return new MixturePoissonDistribution(a2);
    }

    @Override
    public RandomNumberGenerator[] getRandomNumberGenerators() {
        RandomNumberGenerator[] a2 = new RandomNumberGenerator[this.enum.length];
        for (int a3 = 0; a3 < this.enum.length; ++a3) {
            double a4 = this.enum[a3];
            a2[a3] = new Knuth1969(a4);
        }
        return a2;
    }
}

