/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.markovchain;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.ImmutableMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.operation.Inverse;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.ImmutableVector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.dense.DenseVector;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.misc.license.Package;
import com.numericalmethod.suanshu.stats.random.rng.multivariate.MultinomialRVG;
import com.numericalmethod.suanshu.stats.random.rng.univariate.RandomNumberGenerator;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SimpleMC
implements RandomNumberGenerator {
    private MultinomialRVG[] const;
    private int case = -1;
    private final ImmutableVector false;
    private final ImmutableMatrix enum;

    public static int bin(MultinomialRVG rvg) {
        double[] a2 = rvg.nextVector();
        int a3 = 1;
        while (a2[a3 - 1] == 0.0) {
            ++a3;
        }
        return a3;
    }

    public int nextState() {
        int a2;
        MultinomialRVG a3 = this.const[0];
        if (this.case != -1) {
            a3 = this.const[this.case];
        }
        this.case = a2 = SimpleMC.bin(a3);
        return a2;
    }

    public SimpleMC(Vector PI, Matrix A2) {
        int a2 = A2.nRows();
        ArgumentAssertion.assertTrue(PI.size() == a2, "the length of PI should be the same as the number of states", new Object[0]);
        ArgumentAssertion.assertTrue(A2.nCols() == a2, "A should be a square matrix", new Object[0]);
        this.false = new ImmutableVector(PI);
        this.enum = new ImmutableMatrix(A2);
        this.const = new MultinomialRVG[1 + A2.nRows()];
        this.const[0] = new MultinomialRVG(1, PI.toArray());
        for (int a3 = 1; a3 < this.const.length; ++a3) {
            this.const[a3] = new MultinomialRVG(1, A2.getRow(a3).toArray());
        }
    }

    public int nStates() {
        return this.enum.nRows();
    }

    public ImmutableVector PI() {
        return this.false;
    }

    static {
        Package.validate("STATS");
    }

    @Override
    public void seed(long ... seeds) {
        for (int a2 = 0; a2 < this.const.length; ++a2) {
            this.const[a2].seed(seeds);
        }
    }

    public ImmutableMatrix A() {
        return this.enum;
    }

    @Override
    public double nextDouble() {
        return this.nextState();
    }

    public static Vector getStationaryProbabilities(Matrix A2) {
        int a2 = A2.nRows();
        Matrix a3 = A2.t().minus(A2.ONE());
        ((DenseMatrix)a3).setRow(a2, new DenseVector(a2, 1.0));
        DenseVector a4 = new DenseVector(a2, 0.0);
        a4.set(a2, 1.0);
        Vector a5 = new Inverse(a3).multiply(a4);
        return a5;
    }
}

