/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.random.rng.multivariate.mcmc.metropolis;

import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.analysis.function.rn2r1.RealScalarFunction;
import com.numericalmethod.suanshu.stats.random.rng.univariate.BernoulliTrial;
import com.numericalmethod.suanshu.stats.random.rng.univariate.RandomLongGenerator;

public final class MetropolisUtils {
    public static double logAcceptanceRatio(RealScalarFunction logf, Vector currentState, Vector proposedState) {
        double a2 = (Double)logf.evaluate(proposedState);
        double a3 = (Double)logf.evaluate(currentState);
        return a2 - a3;
    }

    private MetropolisUtils() {
        MetropolisUtils a2;
    }

    public static boolean isProposalAccepted(RealScalarFunction logf, RandomLongGenerator uniform, Vector currentState, Vector proposedState) {
        double a2 = MetropolisUtils.logAcceptanceRatio(logf, currentState, proposedState);
        return BernoulliTrial.nextLogTrial(uniform, a2);
    }
}

