/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.random.rng.multivariate.mcmc.proposalfunction;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.diagonal.DiagonalMatrix;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.dense.DenseVector;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.stats.random.rng.multivariate.NormalRVG;
import com.numericalmethod.suanshu.stats.random.rng.multivariate.mcmc.proposalfunction.ProposalFunction;
import com.numericalmethod.suanshu.stats.random.rng.univariate.RandomLongGenerator;
import com.numericalmethod.suanshu.stats.random.rng.univariate.normal.Zignor2005;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class GaussianProposalFunction
extends ProposalFunction {
    private final NormalRVG enum;

    public GaussianProposalFunction(double[] sigma, RandomLongGenerator uniform) {
        this(new DiagonalMatrix(sigma), uniform);
    }

    @Override
    public Vector evaluate(Vector x) {
        double[] a2 = this.enum.nextVector();
        DenseVector a3 = new DenseVector(a2);
        return x.add(a3);
    }

    public GaussianProposalFunction(double sigma, int size, RandomLongGenerator uniform) {
        this(DoubleUtils.rep(sigma, size), uniform);
    }

    public GaussianProposalFunction(Matrix scale, RandomLongGenerator uniform) {
        super(scale.nCols(), scale.nCols());
        ArgumentAssertion.assertTrue(scale.nCols() == scale.nRows(), "the scale matrix must be square", new Object[0]);
        DenseVector a2 = new DenseVector(scale.nRows(), 0.0);
        Matrix a3 = scale.multiply(scale);
        this.enum = new NormalRVG(a2, a3, new Zignor2005(uniform));
    }
}

