/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.random.rng.univariate.uniform.linear;

import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.misc.ExceptionUtils;
import com.numericalmethod.suanshu.stats.random.rng.univariate.uniform.linear.Lehmer;
import com.numericalmethod.suanshu.stats.random.rng.univariate.uniform.linear.LinearCongruentialGenerator;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MRG
implements LinearCongruentialGenerator {
    private final long const;
    private long[] case = null;
    private Lehmer[] false;
    private boolean[] enum;

    public MRG(long m2, long ... a2) {
        this.const = m2;
        this.false = new Lehmer[a2.length];
        this.enum = new boolean[a2.length];
        long[] a3 = new long[a2.length];
        for (int a4 = 0; a4 < a2.length; ++a4) {
            if (a2[a4] != 0L) {
                this.false[a4] = new Lehmer(Math.abs(a2[a4]), m2, 0L);
                this.enum[a4] = a2[a4] > 0L;
            }
            a3[a4] = 8682522807148012L + System.nanoTime();
        }
        this.seed(a3);
    }

    @Override
    public double nextDouble() {
        return (double)this.nextLong() / (double)this.const;
    }

    @Override
    public long modulus() {
        return this.const;
    }

    @Override
    public void seed(long ... x) {
        ArgumentAssertion.assertTrue(x.length == this.false.length, "unmatched number of seeds", new Object[0]);
        this.case = new long[x.length];
        for (int a2 = 0; a2 < this.false.length; ++a2) {
            this.case[a2] = x[a2];
            if (this.false[a2] == null) continue;
            this.false[a2].seed(x[a2]);
        }
    }

    @Override
    public long nextLong() {
        int a2;
        ExceptionUtils.throwIfNotNull(this.case != null ? null : new RuntimeException("the generator has not been seeded"));
        long a3 = 0L;
        for (a2 = this.false.length - 1; a2 >= 0; --a2) {
            if (this.false[a2] == null) continue;
            long l2 = a3 = this.enum[a2] ? a3 + this.false[a2].nextLong() : a3 - this.false[a2].nextLong();
            while (a3 < 0L) {
                a3 += this.const;
            }
            if (a3 <= this.const) continue;
            a3 %= this.const;
        }
        for (a2 = this.false.length - 1; a2 >= 0; --a2) {
            long l3 = this.case[a2] = a2 == 0 ? a3 : this.case[a2 - 1];
            if (this.false[a2] == null) continue;
            this.false[a2].seed(this.case[a2]);
        }
        return a3;
    }

    @Override
    public int order() {
        return this.false.length;
    }
}

