/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.regression.linear.glm;

import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.dense.DenseVector;
import com.numericalmethod.suanshu.stats.regression.linear.LinearModel;
import com.numericalmethod.suanshu.stats.regression.linear.glm.GLMBeta;
import com.numericalmethod.suanshu.stats.regression.linear.glm.GLMFitting;
import com.numericalmethod.suanshu.stats.regression.linear.glm.GLMProblem;
import com.numericalmethod.suanshu.stats.regression.linear.glm.GLMResiduals;
import com.numericalmethod.suanshu.stats.regression.linear.glm.IWLS;
import com.numericalmethod.suanshu.stats.regression.linear.ols.OLSRegression;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class GeneralizedLinearModel
implements LinearModel {
    private GLMBeta const = null;
    private final GLMFitting case;
    private final GLMProblem false;
    private GLMResiduals enum = null;

    @Override
    public GLMBeta beta() {
        if (this.const == null) {
            this.const = new GLMBeta(this.case, this.residuals());
        }
        return this.const;
    }

    @Override
    public GLMResiduals residuals() {
        if (this.enum == null) {
            this.enum = new GLMResiduals(this.false, (Vector)this.case.mu());
        }
        return this.enum;
    }

    @Override
    public double Ey(Vector x) {
        return OLSRegression.Ey(this.beta().betaHat(), x, this.false.intercept());
    }

    public GeneralizedLinearModel(GLMProblem problem) {
        this(problem, new IWLS(1.0E-10, 100));
    }

    public double AIC() {
        double a2 = this.false.getFamily().distribution().AIC(this.false.y(), this.case.mu(), this.case.weights(), this.case.logLikelihood(), this.residuals().deviance(), this.false.nFactors());
        return a2;
    }

    public GeneralizedLinearModel(GLMProblem problem, GLMFitting fitting) {
        this.false = problem;
        this.case = fitting;
        fitting.fit(problem, new DenseVector(problem.nFactors(), 1.0E-4));
    }
}

