/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.regression.linear.glm.distribution;

import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.analysis.function.special.gamma.LogGamma;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.stats.regression.linear.glm.distribution.GLMExponentialDistribution;

public class GLMGamma
implements GLMExponentialDistribution {
    @Override
    public double overdispersion(Vector y, Vector mu, int nFactors) {
        int a2 = y.size();
        double a3 = 0.0;
        for (int a4 = 1; a4 <= a2; ++a4) {
            double a5 = y.get(a4) / mu.get(a4) - 1.0;
            a3 += a5 * a5;
        }
        return a3 /= (double)(a2 - nFactors);
    }

    @Override
    public double variance(double mu) {
        return mu * mu;
    }

    @Override
    public double deviance(double y, double mu) {
        return 2.0 * (-Math.log(DoubleUtils.isZero(y, 0.0) ? 1.0 : Math.abs(y / mu)) + (y - mu) / mu);
    }

    @Override
    public double dispersion(Vector y, Vector mu, int nFactors) {
        return this.overdispersion(y, mu, nFactors);
    }

    @Override
    public double cumulant(double theta) {
        return -Math.log(Math.abs(-theta));
    }

    @Override
    public double AIC(Vector y, Vector mu, Vector weight, double prelogLike, double deviance, int nFactors) {
        int a2 = y.size();
        double a3 = deviance / (double)a2;
        LogGamma a4 = new LogGamma();
        double a5 = prelogLike / a3;
        double a6 = 1.0 / a3;
        for (int a7 = 1; a7 <= a2; ++a7) {
            a5 += a6 * Math.log(a6 * y.get(a7)) - Math.log(y.get(a7)) - a4.evaluate(a6);
        }
        return 2.0 * ((double)(nFactors + 1) - a5);
    }

    @Override
    public double theta(double mu) {
        return -1.0 / mu;
    }
}

