/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.regression.linear.glm.distribution;

import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.analysis.function.FunctionOps;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.stats.regression.linear.glm.distribution.GLMExponentialDistribution;

public class GLMPoisson
implements GLMExponentialDistribution {
    @Override
    public double theta(double mu) {
        return Math.log(mu);
    }

    @Override
    public double overdispersion(Vector y, Vector mu, int nFactors) {
        int a2 = y.size();
        double a3 = 0.0;
        for (int a4 = 1; a4 <= a2; ++a4) {
            double a5 = y.get(a4) - mu.get(a4);
            a3 += a5 * a5 / this.variance(mu.get(a4));
        }
        return a3 /= (double)(a2 - nFactors);
    }

    @Override
    public double dispersion(Vector y, Vector mu, int nFactors) {
        return 1.0;
    }

    @Override
    public double cumulant(double theta) {
        return Math.exp(theta);
    }

    @Override
    public double deviance(double y, double mu) {
        return 2.0 * (y * Math.log(DoubleUtils.isZero(y, 0.0) ? 1.0 : Math.abs(y / mu)) - y + mu);
    }

    @Override
    public double AIC(Vector y, Vector mu, Vector weight, double preLogLike, double deviance, int nFactors) {
        int a2 = y.size();
        double a3 = preLogLike;
        for (int a4 = 1; a4 <= a2; ++a4) {
            a3 += -Math.log(FunctionOps.factorial((int)y.get(a4)));
        }
        return 2.0 * ((double)nFactors - a3);
    }

    @Override
    public double variance(double mu) {
        return mu;
    }
}

