/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.stochasticprocess.univariate.sde.process.ou;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.dense.DenseVector;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.stats.regression.linear.LMProblem;
import com.numericalmethod.suanshu.stats.regression.linear.ols.OLSRegression;
import com.numericalmethod.suanshu.stats.stochasticprocess.univariate.sde.process.ou.OUFitting;
import com.numericalmethod.suanshu.stats.stochasticprocess.univariate.sde.process.ou.OrnsteinUhlenbeckProcess;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class OUFittingOLS
implements OUFitting {
    private final boolean enum;

    @Override
    public OrnsteinUhlenbeckProcess getFittedOU(double[] ts, double dt) {
        int a2 = ts.length;
        ArgumentAssertion.assertTrue(a2 > 1, "in order to fit an OU process, the time series should contain at least two data points.", new Object[0]);
        DenseVector a3 = new DenseVector(Arrays.copyOfRange(ts, 1, a2));
        DenseMatrix a4 = new DenseMatrix(new DenseVector(Arrays.copyOfRange(ts, 0, a2 - 1)));
        LMProblem a5 = new LMProblem((Vector)a3, (Matrix)a4, true);
        OLSRegression a6 = new OLSRegression(a5);
        double a7 = a6.beta().betaHat().get(1);
        double a8 = a6.beta().betaHat().get(2);
        double a9 = -(Math.log(a7) / dt);
        double a10 = a8 / (1.0 - a7);
        double a11 = 1.0;
        if (this.enum) {
            double a12 = a6.residuals().stderr();
            a11 = a12 * Math.sqrt(-(2.0 * Math.log(a7)) / (dt * (1.0 - a7 * a7)));
        }
        OrnsteinUhlenbeckProcess a13 = new OrnsteinUhlenbeckProcess(a10, a9, a11);
        return a13;
    }

    public OUFittingOLS() {
        this(true);
    }

    public OrnsteinUhlenbeckProcess getFittedOU(double[] ts) {
        return this.getFittedOU(ts, 1.0);
    }

    public OUFittingOLS(boolean estimateVolatility) {
        this.enum = estimateVolatility;
    }
}

