/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.stochasticprocess.univariate.sde.process.ou;

import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.stats.random.rng.univariate.RandomNumberGenerator;
import com.numericalmethod.suanshu.stats.random.rng.univariate.normal.RandomStandardNormalGenerator;
import com.numericalmethod.suanshu.stats.random.rng.univariate.normal.StandardNormalRNG;
import com.numericalmethod.suanshu.stats.stochasticprocess.univariate.sde.process.ou.OrnsteinUhlenbeckProcess;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class OUSim
implements RandomNumberGenerator {
    private final OrnsteinUhlenbeckProcess super;
    private double char;
    private final double new;
    private final double const;
    private final double case;
    private final RandomStandardNormalGenerator false;
    private final double enum;

    public OUSim(OrnsteinUhlenbeckProcess ou, double dt, double x0, RandomStandardNormalGenerator rng) {
        ArgumentAssertion.assertPositive(dt, "dt");
        this.super = ou;
        this.const = dt;
        this.char = x0;
        this.false = rng;
        double a2 = ou.mu();
        double a3 = ou.theta();
        double a4 = ou.sigma();
        this.new = Math.exp(-(a3 * dt));
        this.case = a2 * (1.0 - this.new);
        this.enum = a4 * Math.sqrt((1.0 - this.new * this.new) / (2.0 * a3));
    }

    public OUSim(OrnsteinUhlenbeckProcess ou) {
        this(ou, 1.0);
    }

    @Override
    public double nextDouble() {
        double a2;
        double a3 = this.false.nextDouble();
        this.char = a2 = this.new * this.char + this.case + this.enum * a3;
        return a2;
    }

    public OrnsteinUhlenbeckProcess getProcess() {
        return this.super;
    }

    public OUSim(OrnsteinUhlenbeckProcess ou, double dt, double x0) {
        this(ou, dt, x0, new StandardNormalRNG());
    }

    public double dt() {
        return this.const;
    }

    public OUSim(OrnsteinUhlenbeckProcess ou, double dt) {
        this(ou, dt, ou.mu());
    }

    @Override
    public void seed(long ... seeds) {
        this.false.seed(seeds);
    }
}

