/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.stochasticprocess.univariate.sde.process.ou;

import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.misc.license.Package;
import com.numericalmethod.suanshu.stats.stochasticprocess.univariate.sde.Ft;
import com.numericalmethod.suanshu.stats.stochasticprocess.univariate.sde.SDE;
import com.numericalmethod.suanshu.stats.stochasticprocess.univariate.sde.coefficients.Diffusion;
import com.numericalmethod.suanshu.stats.stochasticprocess.univariate.sde.coefficients.Drift;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class OrnsteinUhlenbeckProcess
extends SDE {
    private final double case;
    private final double false;
    private final double enum;

    public OrnsteinUhlenbeckProcess(OrnsteinUhlenbeckProcess that) {
        this(that.enum, that.case, that.false);
    }

    public double theta() {
        return this.case;
    }

    private static Diffusion do(final double a2) {
        ArgumentAssertion.assertPositive(a2, "sigma(the volatility)");
        return new Diffusion(){
            {
                2 a22;
            }

            @Override
            public double evaluate(Ft ft) {
                return a2;
            }
        };
    }

    private static Drift do(final double a2, final double a3) {
        return new Drift(){

            @Override
            public double evaluate(Ft ft) {
                return a3 * (a2 - ft.Xt());
            }
            {
                1 a22;
            }
        };
    }

    public double sigma() {
        return this.false;
    }

    public OrnsteinUhlenbeckProcess(double mu, double theta) {
        this(mu, theta, 1.0);
    }

    public OrnsteinUhlenbeckProcess(double mu, double theta, double sigma) {
        super(OrnsteinUhlenbeckProcess.do(mu, theta), OrnsteinUhlenbeckProcess.do(sigma));
        this.enum = mu;
        this.case = theta;
        this.false = sigma;
    }

    static {
        Package.validate("STATS");
    }

    public double mu() {
        return this.enum;
    }
}

