/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.test.distribution.normality;

import com.numericalmethod.suanshu.stats.descriptive.moment.Kurtosis;
import com.numericalmethod.suanshu.stats.descriptive.moment.Skewness;
import com.numericalmethod.suanshu.stats.distribution.univariate.ChiSquareDistribution;
import com.numericalmethod.suanshu.stats.distribution.univariate.ProbabilityDistribution;
import com.numericalmethod.suanshu.stats.test.HypothesisTest;
import com.numericalmethod.suanshu.stats.test.distribution.normality.JarqueBeraDistribution;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class JarqueBera
extends HypothesisTest {
    private final boolean case;
    private final double false;
    public final int nSim = 50000;
    private final double enum;

    @Override
    public String getNullHypothesis() {
        return "both the skewness and the excess kurtosis are 0";
    }

    @Override
    public double statistics() {
        int a2 = this.nObs();
        double a3 = (this.false * this.false + this.enum * this.enum / 4.0) * (double)a2 / 6.0;
        return a3;
    }

    @Override
    public double pValue() {
        int a2 = this.nObs();
        ProbabilityDistribution a3 = new ChiSquareDistribution(2.0);
        if (this.case && a2 <= 2000) {
            a3 = new JarqueBeraDistribution(a2, 50000);
        }
        double a4 = this.statistics();
        double a5 = JarqueBera.oneSidedPvalue(a3, a4);
        return a5;
    }

    @Override
    public String getAlternativeHypothesis() {
        return "either the skewness or the excess kurtosis is non-zero";
    }

    public JarqueBera(double[] sample, boolean isExact) {
        super(new double[][]{sample});
        this.case = isExact;
        Skewness a2 = new Skewness(sample);
        this.false = a2.sample();
        Kurtosis a3 = new Kurtosis(sample);
        this.enum = a3.sample();
    }

    public JarqueBera(double[] sample) {
        this(sample, false);
    }
}

