/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.test.regression.linear.heteroskedasticity;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.stats.distribution.univariate.ChiSquareDistribution;
import com.numericalmethod.suanshu.stats.regression.linear.LMProblem;
import com.numericalmethod.suanshu.stats.regression.linear.ols.OLSRegression;
import com.numericalmethod.suanshu.stats.regression.linear.residualanalysis.LMResiduals;
import com.numericalmethod.suanshu.stats.test.HypothesisTest;

public abstract class Heteroskedasticity
extends HypothesisTest {
    protected final LMResiduals residuals;
    protected final int N;

    @Override
    public String getNullHypothesis() {
        return "there is homoskedasticity";
    }

    protected OLSRegression getAuxiliaryOLSRegression(Vector y, LMResiduals residuals) {
        LMProblem a2 = new LMProblem(y, (Matrix)residuals.getProblem().X(), true);
        OLSRegression a3 = new OLSRegression(a2);
        return a3;
    }

    @Override
    public String getAlternativeHypothesis() {
        return "there is conditional heteroscedasticity";
    }

    @Override
    public double pValue() {
        return Heteroskedasticity.oneSidedPvalue(this.getX2(), this.statistics());
    }

    protected abstract OLSRegression getAuxiliaryRegression();

    public Heteroskedasticity(LMResiduals residuals) {
        super(new double[0][]);
        this.residuals = residuals;
        this.N = residuals.getProblem().nObs();
    }

    protected ChiSquareDistribution getX2() {
        return new ChiSquareDistribution(this.residuals.getProblem().nExogenousFactors());
    }

    @Override
    public double statistics() {
        OLSRegression a2 = this.getAuxiliaryRegression();
        return (double)this.N * a2.residuals().R2();
    }
}

