/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.test.timeseries.adf;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.operation.MatrixFactory;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.stats.regression.linear.LMProblem;
import com.numericalmethod.suanshu.stats.regression.linear.ols.OLSRegression;
import com.numericalmethod.suanshu.stats.test.HypothesisTest;
import com.numericalmethod.suanshu.stats.test.timeseries.adf.ADFDistribution;
import com.numericalmethod.suanshu.stats.test.timeseries.adf.TrendType;
import com.numericalmethod.suanshu.stats.timeseries.datastructure.univariate.UnivariateTimeSeriesUtils;
import com.numericalmethod.suanshu.stats.timeseries.datastructure.univariate.realtime.inttime.SimpleTimeSeries;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class AugmentedDickeyFuller
extends HypothesisTest {
    private final ADFDistribution false;
    private final OLSRegression enum;

    @Override
    public double pValue() {
        double a2 = this.statistics();
        double a3 = this.false.cdf(a2);
        return a3;
    }

    public AugmentedDickeyFuller(double[] x) {
        this(x, TrendType.CONSTANT_TIME, (int)Math.pow(x.length - 1, 0.3333333333333333), null);
    }

    @Override
    public String getAlternativeHypothesis() {
        return "there is no unit root in the process, hence stationarity";
    }

    @Override
    public double statistics() {
        double a2 = this.enum.beta().betaHat().get(2);
        double a3 = this.enum.beta().stderr().get(2);
        double a4 = (a2 - 1.0) / a3;
        return a4;
    }

    private AugmentedDickeyFuller(SimpleTimeSeries a2, TrendType a3, int a4, ADFDistribution a5) {
        super(new double[0][]);
        Matrix a6;
        SimpleTimeSeries a7;
        AugmentedDickeyFuller a8;
        ArgumentAssertion.assertTrue(0 <= a4 && a4 < a2.size(), "0 <= lagOrder < sample size", new Object[0]);
        int a9 = a2.size();
        if (a4 == 0) {
            a7 = a2.drop(1);
            a6 = MatrixFactory.cbind(new DenseMatrix(DoubleUtils.seq(2.0, (double)a9, 1.0), a9 - 2 + 1, 1), UnivariateTimeSeriesUtils.toMatrix(a2.lag(1)));
        } else {
            int a10 = a9 - a4 - 2 + 1;
            a7 = a2.drop(a4 + 1);
            a6 = MatrixFactory.cbind(new DenseMatrix(DoubleUtils.seq(2.0 + (double)a4, (double)a9, 1.0), a10, 1), UnivariateTimeSeriesUtils.toMatrix(a2.lag(1, a10)));
            Matrix[] a11 = new Matrix[a4 + 1];
            for (int a12 = 1; a12 <= a4; ++a12) {
                a11[a12] = UnivariateTimeSeriesUtils.toMatrix(a2.lag(a12, a10 + 1).diff(1));
            }
            a11[0] = a6;
            a6 = MatrixFactory.cbind(a11);
        }
        LMProblem a13 = new LMProblem(UnivariateTimeSeriesUtils.toVector(a7), a6, true);
        a8.enum = new OLSRegression(a13);
        a8.false = a5 != null ? a5 : a3.getDistribution(a2.size());
    }

    @Override
    public String getNullHypothesis() {
        return "there is a unit root in the process, hence non-stationarity";
    }

    public AugmentedDickeyFuller(double[] x, TrendType type, int lagOrder, ADFDistribution dist) {
        this(new SimpleTimeSeries(x), type, lagOrder, dist);
    }
}

