/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.test.timeseries.adf;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.operation.MatrixFactory;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.stats.descriptive.rank.Quantile;
import com.numericalmethod.suanshu.stats.regression.linear.LMProblem;
import com.numericalmethod.suanshu.stats.regression.linear.ols.OLSRegression;
import com.numericalmethod.suanshu.stats.stochasticprocess.univariate.filtration.Bt;
import com.numericalmethod.suanshu.stats.stochasticprocess.univariate.filtration.F_Sum_BtDt;
import com.numericalmethod.suanshu.stats.stochasticprocess.univariate.filtration.F_Sum_tBtDt;
import com.numericalmethod.suanshu.stats.stochasticprocess.univariate.filtration.Filtration;
import com.numericalmethod.suanshu.stats.stochasticprocess.univariate.filtration.FiltrationFunction;
import com.numericalmethod.suanshu.stats.stochasticprocess.univariate.integration.IntegralDB;
import com.numericalmethod.suanshu.stats.stochasticprocess.univariate.integration.IntegralDt;
import com.numericalmethod.suanshu.stats.test.timeseries.adf.ADFDistribution;
import com.numericalmethod.suanshu.stats.test.timeseries.adf.table.ADFDistributionTable;
import com.numericalmethod.suanshu.stats.test.timeseries.adf.table.ADFDistributionTable_CONSTANT_TIME_lag0;
import com.numericalmethod.suanshu.stats.test.timeseries.adf.table.ADFDistributionTable_CONSTANT_lag0;
import com.numericalmethod.suanshu.stats.test.timeseries.adf.table.ADFDistributionTable_NO_CONSTANT_lag0;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public enum TrendType {
    NO_CONSTANT(new ADFDistributionTable_NO_CONSTANT_lag0()){

        @Override
        public double fromRegression(Vector y, Matrix X) {
            LMProblem a2 = new LMProblem(y, X, false);
            return TrendType.do(a2);
        }
        {
            1 a3;
        }

        @Override
        public double fromFiltration(final Filtration Ft2) {
            Bt a2 = new Bt();
            FiltrationFunction a3 = new FiltrationFunction(){

                @Override
                public double evaluate(int t) {
                    double a2 = Ft2.B(t);
                    return a2 * a2;
                }
                {
                    1 a2;
                }
            };
            return TrendType.do(a2, a3, Ft2);
        }
    }
    ,
    CONSTANT(new ADFDistributionTable_CONSTANT_lag0()){
        {
            2 a3;
        }

        @Override
        public double fromFiltration(final Filtration Ft2) {
            F_Sum_BtDt a2 = new F_Sum_BtDt(){

                @Override
                public double evaluate(int t) {
                    double a2 = Ft2.B(t);
                    return a2 - this.sum_BtDt();
                }
                {
                    1 a2;
                }
            };
            F_Sum_BtDt a3 = new F_Sum_BtDt(){

                @Override
                public double evaluate(int t) {
                    double a2 = Ft2.B(t);
                    double a3 = a2 - this.sum_BtDt();
                    return a3 * a3;
                }
                {
                    2 a2;
                }
            };
            return TrendType.do(a2, a3, Ft2);
        }

        @Override
        public double fromRegression(Vector y, Matrix X) {
            LMProblem a2 = new LMProblem(y, X, true);
            return TrendType.do(a2);
        }
    }
    ,
    CONSTANT_TIME(new ADFDistributionTable_CONSTANT_TIME_lag0()){

        @Override
        public double fromFiltration(final Filtration Ft2) {
            F_Sum_tBtDt a2 = new F_Sum_tBtDt(){
                {
                    1 a2;
                }

                @Override
                public double evaluate(int t) {
                    double a2 = Ft2.B(t);
                    return a2 - this.sum_BtDt() - 12.0 * (Ft2.time(t) - 0.5) * this.sum_tBtDt();
                }
            };
            F_Sum_tBtDt a3 = new F_Sum_tBtDt(){
                {
                    2 a2;
                }

                @Override
                public double evaluate(int t) {
                    double a2 = Ft2.B(t);
                    double a3 = a2 - this.sum_BtDt() - 12.0 * (Ft2.time(t) - 0.5) * this.sum_tBtDt();
                    return a3 * a3;
                }
            };
            return TrendType.do(a2, a3, Ft2);
        }
        {
            3 a3;
        }

        @Override
        public double fromRegression(Vector y, Matrix X) {
            Matrix a2 = MatrixFactory.cbind(X, new DenseMatrix(DoubleUtils.seq(y.size(), 1.0, 1.0), y.size(), 1));
            LMProblem a3 = new LMProblem(y, a2, true);
            return TrendType.do(a3);
        }
    };

    private final ADFDistributionTable enum;

    private TrendType(ADFDistributionTable a2) {
        TrendType a3;
        a3.enum = a2;
    }

    private static double do(LMProblem a2) {
        OLSRegression a3 = new OLSRegression(a2);
        double a4 = a3.beta().betaHat().get(1);
        double a5 = a3.beta().stderr().get(1);
        double a6 = a4 / a5;
        return a6;
    }

    abstract double fromFiltration(Filtration var1);

    private static double do(FiltrationFunction a2, FiltrationFunction a3, Filtration a4) {
        double a5 = new IntegralDB(a2).value(a4);
        double a6 = new IntegralDt(a3).value(a4);
        a6 = Math.sqrt(a6);
        double a7 = a5 / a6;
        return a7;
    }

    abstract double fromRegression(Vector var1, Matrix var2);

    public ADFDistribution getDistribution(int sampleSize) {
        return new ADFDistribution(this.enum.getObservations(sampleSize), Quantile.QuantileType.INVERSE_OF_EMPIRICAL_CDF){
            {
                4 a4;
                super(a2, a3);
            }
        };
    }
}

