/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.timeseries.linear.univariate.arima;

import com.numericalmethod.suanshu.analysis.function.polynomial.Polynomial;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.misc.license.Package;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.stats.timeseries.linear.univariate.stationaryprocess.arma.ARMAXModel;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ARIMAXModel {
    private final double[] char;
    private final double[] new;
    private final int const;
    private final double[] case;
    private final double false;
    private final double enum;

    public ARIMAXModel(ARIMAXModel that) {
        this.enum = that.enum;
        this.char = Arrays.copyOf(that.char, that.char.length);
        this.case = Arrays.copyOf(that.case, that.case.length);
        this.new = that.new != null ? Arrays.copyOf(that.new, that.new.length) : null;
        this.const = that.const;
        this.false = that.false;
    }

    public int maxPQ() {
        return Math.max(this.p(), this.q());
    }

    public ARIMAXModel(double[] AR, int d, double[] MA, double[] psi) {
        this(0.0, AR, d, MA, psi, 1.0);
    }

    public double[] psi() {
        return this.new != null ? Arrays.copyOf(this.new, this.new.length) : null;
    }

    public double AR(int i) {
        return i <= this.p() ? this.char[i] : 0.0;
    }

    public ARIMAXModel(double[] AR, int d, double[] MA, double[] psi, double sigma) {
        this(0.0, AR, d, MA, psi, sigma);
    }

    public int p() {
        return this.char.length - 1;
    }

    public ARIMAXModel(double mu, double[] AR, int d, double[] MA, double[] psi, double sigma) {
        int a2;
        ArgumentAssertion.assertTrue(AR != null || MA != null, "at least one of AR and MA terms cannot be null", new Object[0]);
        ArgumentAssertion.assertNonNegative(d, "d");
        ArgumentAssertion.assertNonNegative(sigma, "sigma");
        this.enum = mu;
        this.char = new double[AR != null ? AR.length + 1 : 1];
        this.char[0] = 1.0;
        for (a2 = 1; a2 < this.char.length; ++a2) {
            this.char[a2] = AR[a2 - 1];
        }
        this.case = new double[MA != null ? MA.length + 1 : 1];
        this.case[0] = 1.0;
        for (a2 = 1; a2 < this.case.length; ++a2) {
            this.case[a2] = MA[a2 - 1];
        }
        this.new = psi != null ? Arrays.copyOf(psi, psi.length) : null;
        this.const = d;
        this.false = sigma;
    }

    static {
        Package.validate("STATS");
    }

    public int d() {
        return this.const;
    }

    public ARIMAXModel(double mu, double[] AR, int d, double[] MA, double[] psi) {
        this(mu, AR, d, MA, psi, 1.0);
    }

    public Polynomial thetaPolynomial() {
        double[] a2 = new double[this.q() + 1];
        a2[0] = 1.0;
        for (int a3 = 1; a3 < a2.length; ++a3) {
            a2[a3] = this.MA(a3);
        }
        DoubleUtils.reverse(a2);
        return new Polynomial(a2);
    }

    public double[] phi() {
        return Arrays.copyOf(this.char, this.char.length);
    }

    public double[] theta() {
        return Arrays.copyOf(this.case, this.case.length);
    }

    public int q() {
        return this.case.length - 1;
    }

    public ARMAXModel getARMAX() {
        return new ARMAXModel(this.enum, Arrays.copyOfRange(this.char, 1, this.char.length), Arrays.copyOfRange(this.case, 1, this.case.length), this.new, this.false);
    }

    public String toString() {
        int a2;
        StringBuilder a3 = new StringBuilder();
        a3.append("x_t = ");
        a3.append(this.enum);
        a3.append(" + (");
        if (this.char != null) {
            for (a2 = 1; a2 < this.char.length; ++a2) {
                a3.append(this.char[a2]);
                a3.append(String.format("*x_{t-%d}", a2));
                if (a2 == this.char.length - 1) continue;
                a3.append("+");
            }
        }
        a3.append(")");
        a3.append(" + (");
        if (this.case != null) {
            for (a2 = 1; a2 < this.case.length; ++a2) {
                a3.append(this.case[a2]);
                a3.append(String.format("*e_{t-%d}", a2));
                if (a2 == this.case.length - 1) continue;
                a3.append("+");
            }
        }
        a3.append(")");
        if (this.new != null) {
            a3.append(" + (");
            for (a2 = 0; a2 < this.new.length; ++a2) {
                a3.append(this.new[a2]);
                a3.append(String.format("*D_{t-%d}", a2));
                if (a2 == this.new.length - 1) continue;
                a3.append("+");
            }
            a3.append(")");
        }
        a3.append(" + e_t");
        a3.append(String.format("; var(e_t) = %f, d = %d", this.false, this.const));
        return a3.toString();
    }

    public double MA(int i) {
        return i <= this.q() ? this.case[i] : 0.0;
    }

    public Polynomial phiPolynomial() {
        double[] a2 = new double[this.p() + 1];
        a2[0] = 1.0;
        for (int a3 = 1; a3 < a2.length; ++a3) {
            a2[a3] = -this.AR(a3);
        }
        DoubleUtils.reverse(a2);
        return new Polynomial(a2);
    }

    public double mu() {
        return this.enum;
    }

    public double sigma() {
        return this.false;
    }
}

