/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.timeseries.linear.univariate.stationaryprocess.garch;

import com.numericalmethod.suanshu.analysis.function.tuple.Pair;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.stats.random.rng.univariate.RandomNumberGenerator;
import com.numericalmethod.suanshu.stats.random.rng.univariate.normal.StandardNormalRNG;
import com.numericalmethod.suanshu.stats.timeseries.linear.univariate.stationaryprocess.garch.GARCHModel;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class GARCHSim
implements RandomNumberGenerator {
    private final GARCHModel const;
    private final RandomNumberGenerator case;
    private double[] false;
    private double[] enum;

    @Override
    public double nextDouble() {
        return this.nextPair().x();
    }

    public GARCHSim(GARCHModel model, double[] z, RandomNumberGenerator rng) {
        this.const = model;
        this.case = rng;
        double a2 = model.var();
        this.false = DoubleUtils.rep(a2, model.p());
        this.enum = Arrays.copyOfRange(z, 0, model.q());
        int a3 = 0;
        while (a3 < model.q()) {
            int n = a3++;
            this.enum[n] = this.enum[n] * a2;
        }
    }

    public GARCHSim(GARCHModel model, RandomNumberGenerator rng) {
        this(model, DoubleUtils.rep(0.0, model.q()), rng);
    }

    @Override
    public void seed(long ... seeds) {
        this.case.seed(seeds);
    }

    public GARCHSim(GARCHModel model) {
        this(model, new StandardNormalRNG());
    }

    public Pair nextPair() {
        double a2 = this.const.sigma2(this.enum, this.false);
        double a3 = this.case.nextDouble();
        double a4 = Math.sqrt(a2) * a3;
        if (this.false.length > 0) {
            DoubleUtils.rightShift(this.false);
            this.false[0] = a2;
        }
        if (this.enum.length > 0) {
            DoubleUtils.rightShift(this.enum);
            this.enum[0] = a4 * a4;
        }
        return new Pair(a4, a2);
    }
}

