/*
 * Decompiled with CFR 0.152.
 */
package com.bpodgursky.jbool_expressions.rules;

import com.bpodgursky.jbool_expressions.And;
import com.bpodgursky.jbool_expressions.Expression;
import com.bpodgursky.jbool_expressions.NExpression;
import com.bpodgursky.jbool_expressions.Or;
import com.bpodgursky.jbool_expressions.rules.Rule;
import com.google.common.collect.Lists;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimplifyNExprChildren<K>
extends Rule<NExpression<K>, K> {
    @Override
    public Expression<K> applyInternal(NExpression<K> input) {
        for (int i = 0; i < input.expressions.length; ++i) {
            Expression child1 = input.expressions[i];
            for (int j = 0; j < input.expressions.length; ++j) {
                Expression child2 = input.expressions[j];
                if (i == j || !this.checkExprSubset(child1, child2, input)) continue;
                return this.removeChild(input, i);
            }
        }
        return input;
    }

    private boolean checkContains(NExpression expr, Expression toCheck) {
        for (int i = 0; i < expr.expressions.length; ++i) {
            Expression child = expr.expressions[i];
            if (!child.equals(toCheck)) continue;
            return true;
        }
        return false;
    }

    private boolean checkContainsAllChildren(NExpression expr1, NExpression toCheck) {
        int j = 0;
        for (int i = 0; i < expr1.expressions.length && j < toCheck.expressions.length; ++i) {
            if (!expr1.expressions[i].equals(toCheck.expressions[j])) continue;
            ++j;
        }
        return j == toCheck.expressions.length;
    }

    private boolean checkExprSubset(Expression<K> expr, Expression<K> exprCheckSubset, Expression<K> parent) {
        if (expr.equals(exprCheckSubset)) {
            return true;
        }
        if (expr instanceof Or && exprCheckSubset instanceof Or && parent instanceof And) {
            return this.checkContainsAllChildren((Or)expr, (Or)exprCheckSubset);
        }
        if (expr instanceof And && exprCheckSubset instanceof And && parent instanceof Or) {
            return this.checkContainsAllChildren((And)expr, (And)exprCheckSubset);
        }
        if (expr instanceof And && parent instanceof Or || expr instanceof Or && parent instanceof And) {
            return this.checkContains((NExpression)expr, exprCheckSubset);
        }
        return false;
    }

    private NExpression<K> removeChild(NExpression<K> node, int index) {
        ArrayList copy = Lists.newArrayList();
        for (int i = 0; i < node.expressions.length; ++i) {
            if (i == index) continue;
            copy.add(node.expressions[i]);
        }
        if (node instanceof And) {
            return And.of(copy);
        }
        if (node instanceof Or) {
            return Or.of(copy);
        }
        throw new RuntimeException("Unknown child of NExpression");
    }

    @Override
    protected boolean isApply(Expression<K> input) {
        return input instanceof NExpression;
    }
}

