/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.z3;

import com.microsoft.z3.ApplyResult;
import com.microsoft.z3.BoolExpr;
import com.microsoft.z3.Context;
import com.microsoft.z3.Native;
import com.microsoft.z3.Params;
import com.microsoft.z3.Tactic;
import com.microsoft.z3.Z3Exception;
import com.microsoft.z3.Z3Object;
import com.microsoft.z3.enumerations.Z3_goal_prec;

public class Goal
extends Z3Object {
    public Z3_goal_prec getPrecision() {
        return Z3_goal_prec.fromInt(Native.goalPrecision(this.getContext().nCtx(), this.getNativeObject()));
    }

    public boolean isPrecise() {
        return this.getPrecision() == Z3_goal_prec.Z3_GOAL_PRECISE;
    }

    public boolean isUnderApproximation() {
        return this.getPrecision() == Z3_goal_prec.Z3_GOAL_UNDER;
    }

    public boolean isOverApproximation() {
        return this.getPrecision() == Z3_goal_prec.Z3_GOAL_OVER;
    }

    public boolean isGarbage() {
        return this.getPrecision() == Z3_goal_prec.Z3_GOAL_UNDER_OVER;
    }

    public void add(BoolExpr ... boolExprArray) {
        this.getContext().checkContextMatch(boolExprArray);
        for (BoolExpr boolExpr : boolExprArray) {
            Native.goalAssert(this.getContext().nCtx(), this.getNativeObject(), boolExpr.getNativeObject());
        }
    }

    public boolean inconsistent() {
        return Native.goalInconsistent(this.getContext().nCtx(), this.getNativeObject());
    }

    public int getDepth() {
        return Native.goalDepth(this.getContext().nCtx(), this.getNativeObject());
    }

    public void reset() {
        Native.goalReset(this.getContext().nCtx(), this.getNativeObject());
    }

    public int size() {
        return Native.goalSize(this.getContext().nCtx(), this.getNativeObject());
    }

    public BoolExpr[] getFormulas() {
        int n = this.size();
        BoolExpr[] boolExprArray = new BoolExpr[n];
        for (int i = 0; i < n; ++i) {
            boolExprArray[i] = new BoolExpr(this.getContext(), Native.goalFormula(this.getContext().nCtx(), this.getNativeObject(), i));
        }
        return boolExprArray;
    }

    public int getNumExprs() {
        return Native.goalNumExprs(this.getContext().nCtx(), this.getNativeObject());
    }

    public boolean isDecidedSat() {
        return Native.goalIsDecidedSat(this.getContext().nCtx(), this.getNativeObject());
    }

    public boolean isDecidedUnsat() {
        return Native.goalIsDecidedUnsat(this.getContext().nCtx(), this.getNativeObject());
    }

    public Goal translate(Context context) {
        return new Goal(context, Native.goalTranslate(this.getContext().nCtx(), this.getNativeObject(), context.nCtx()));
    }

    public Goal simplify() {
        Tactic tactic = this.getContext().mkTactic("simplify");
        ApplyResult applyResult = tactic.apply(this);
        if (applyResult.getNumSubgoals() == 0) {
            throw new Z3Exception("No subgoals");
        }
        return applyResult.getSubgoals()[0];
    }

    public Goal simplify(Params params) {
        Tactic tactic = this.getContext().mkTactic("simplify");
        ApplyResult applyResult = tactic.apply(this, params);
        if (applyResult.getNumSubgoals() == 0) {
            throw new Z3Exception("No subgoals");
        }
        return applyResult.getSubgoals()[0];
    }

    public String toString() {
        return Native.goalToString(this.getContext().nCtx(), this.getNativeObject());
    }

    public BoolExpr AsBoolExpr() {
        int n = this.size();
        if (n == 0) {
            return this.getContext().mkTrue();
        }
        if (n == 1) {
            return this.getFormulas()[0];
        }
        return this.getContext().mkAnd(this.getFormulas());
    }

    Goal(Context context, long l) {
        super(context, l);
    }

    Goal(Context context, boolean bl, boolean bl2, boolean bl3) {
        super(context, Native.mkGoal(context.nCtx(), bl, bl2, bl3));
    }

    @Override
    void incRef() {
        Native.goalIncRef(this.getContext().nCtx(), this.getNativeObject());
    }

    @Override
    void addToReferenceQueue() {
        this.getContext().getGoalDRQ().storeReference(this.getContext(), this);
    }
}

